/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.util.Assert;

public final class Saml2AuthenticationRequestContext {
    private final RelyingPartyRegistration relyingPartyRegistration;
    private final String issuer;
    private final String assertionConsumerServiceUrl;
    private final String relayState;

    private Saml2AuthenticationRequestContext(RelyingPartyRegistration relyingPartyRegistration, String issuer, String assertionConsumerServiceUrl, String relayState) {
        Assert.hasText((String)issuer, (String)"issuer cannot be null or empty");
        Assert.notNull((Object)relyingPartyRegistration, (String)"relyingPartyRegistration cannot be null");
        Assert.hasText((String)assertionConsumerServiceUrl, (String)"spAssertionConsumerServiceUrl cannot be null or empty");
        this.issuer = issuer;
        this.relyingPartyRegistration = relyingPartyRegistration;
        this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
        this.relayState = relayState;
    }

    public RelyingPartyRegistration getRelyingPartyRegistration() {
        return this.relyingPartyRegistration;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getAssertionConsumerServiceUrl() {
        return this.assertionConsumerServiceUrl;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public String getDestination() {
        return this.getRelyingPartyRegistration().getProviderDetails().getWebSsoUrl();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String issuer;
        private String assertionConsumerServiceUrl;
        private String relayState;
        private RelyingPartyRegistration relyingPartyRegistration;

        private Builder() {
        }

        public Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public Builder relyingPartyRegistration(RelyingPartyRegistration relyingPartyRegistration) {
            this.relyingPartyRegistration = relyingPartyRegistration;
            return this;
        }

        public Builder assertionConsumerServiceUrl(String assertionConsumerServiceUrl) {
            this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
            return this;
        }

        public Builder relayState(String relayState) {
            this.relayState = relayState;
            return this;
        }

        public Saml2AuthenticationRequestContext build() {
            return new Saml2AuthenticationRequestContext(this.relyingPartyRegistration, this.issuer, this.assertionConsumerServiceUrl, this.relayState);
        }
    }
}

