/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.security.saml2.credentials.Saml2X509Credential;
import org.springframework.util.Assert;

public class RelyingPartyRegistration {
    private final String registrationId;
    private final String remoteIdpEntityId;
    private final String assertionConsumerServiceUrlTemplate;
    private final String idpWebSsoUrl;
    private final List<Saml2X509Credential> credentials;
    private final String localEntityIdTemplate;

    private RelyingPartyRegistration(String idpEntityId, String registrationId, String assertionConsumerServiceUrlTemplate, String idpWebSsoUri, List<Saml2X509Credential> credentials, String localEntityIdTemplate) {
        Assert.hasText((String)idpEntityId, (String)"idpEntityId cannot be empty");
        Assert.hasText((String)registrationId, (String)"registrationId cannot be empty");
        Assert.hasText((String)assertionConsumerServiceUrlTemplate, (String)"assertionConsumerServiceUrlTemplate cannot be empty");
        Assert.hasText((String)localEntityIdTemplate, (String)"localEntityIdTemplate cannot be empty");
        Assert.notEmpty(credentials, (String)"credentials cannot be empty");
        Assert.notNull((Object)idpWebSsoUri, (String)"idpWebSsoUri cannot be empty");
        for (Saml2X509Credential c : credentials) {
            Assert.notNull((Object)c, (String)"credentials cannot contain null elements");
        }
        this.registrationId = registrationId;
        this.remoteIdpEntityId = idpEntityId;
        this.assertionConsumerServiceUrlTemplate = assertionConsumerServiceUrlTemplate;
        this.credentials = Collections.unmodifiableList(new LinkedList<Saml2X509Credential>(credentials));
        this.idpWebSsoUrl = idpWebSsoUri;
        this.localEntityIdTemplate = localEntityIdTemplate;
    }

    public String getRemoteIdpEntityId() {
        return this.remoteIdpEntityId;
    }

    public String getRegistrationId() {
        return this.registrationId;
    }

    public String getAssertionConsumerServiceUrlTemplate() {
        return this.assertionConsumerServiceUrlTemplate;
    }

    public String getIdpWebSsoUrl() {
        return this.idpWebSsoUrl;
    }

    public String getLocalEntityIdTemplate() {
        return this.localEntityIdTemplate;
    }

    public List<Saml2X509Credential> getCredentials() {
        return this.credentials;
    }

    public List<Saml2X509Credential> getVerificationCredentials() {
        return this.filterCredentials(c -> c.isSignatureVerficationCredential());
    }

    public List<Saml2X509Credential> getSigningCredentials() {
        return this.filterCredentials(c -> c.isSigningCredential());
    }

    public List<Saml2X509Credential> getEncryptionCredentials() {
        return this.filterCredentials(c -> c.isEncryptionCredential());
    }

    public List<Saml2X509Credential> getDecryptionCredentials() {
        return this.filterCredentials(c -> c.isDecryptionCredential());
    }

    private List<Saml2X509Credential> filterCredentials(Function<Saml2X509Credential, Boolean> filter) {
        LinkedList<Saml2X509Credential> result = new LinkedList<Saml2X509Credential>();
        for (Saml2X509Credential c : this.getCredentials()) {
            if (!filter.apply(c).booleanValue()) continue;
            result.add(c);
        }
        return result;
    }

    public static Builder withRegistrationId(String registrationId) {
        Assert.hasText((String)registrationId, (String)"registrationId cannot be empty");
        return new Builder(registrationId);
    }

    public static class Builder {
        private String registrationId;
        private String remoteIdpEntityId;
        private String idpWebSsoUrl;
        private String assertionConsumerServiceUrlTemplate;
        private List<Saml2X509Credential> credentials = new LinkedList<Saml2X509Credential>();
        private String localEntityIdTemplate = "{baseUrl}/saml2/service-provider-metadata/{registrationId}";

        private Builder(String registrationId) {
            this.registrationId = registrationId;
        }

        public Builder registrationId(String id) {
            this.registrationId = id;
            return this;
        }

        public Builder remoteIdpEntityId(String entityId) {
            this.remoteIdpEntityId = entityId;
            return this;
        }

        public Builder assertionConsumerServiceUrlTemplate(String assertionConsumerServiceUrlTemplate) {
            this.assertionConsumerServiceUrlTemplate = assertionConsumerServiceUrlTemplate;
            return this;
        }

        public Builder idpWebSsoUrl(String url) {
            this.idpWebSsoUrl = url;
            return this;
        }

        public Builder credentials(Consumer<Collection<Saml2X509Credential>> credentials) {
            credentials.accept(this.credentials);
            return this;
        }

        public Builder localEntityIdTemplate(String template) {
            this.localEntityIdTemplate = template;
            return this;
        }

        public RelyingPartyRegistration build() {
            return new RelyingPartyRegistration(this.remoteIdpEntityId, this.registrationId, this.assertionConsumerServiceUrlTemplate, this.idpWebSsoUrl, this.credentials, this.localEntityIdTemplate);
        }
    }
}

