/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.rsocket.authentication;

import org.springframework.core.Ordered;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.rsocket.api.PayloadExchange;
import org.springframework.security.rsocket.api.PayloadInterceptor;
import org.springframework.security.rsocket.api.PayloadInterceptorChain;
import org.springframework.security.rsocket.authentication.BasicAuthenticationPayloadExchangeConverter;
import org.springframework.security.rsocket.authentication.PayloadExchangeAuthenticationConverter;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class AuthenticationPayloadInterceptor
implements PayloadInterceptor,
Ordered {
    private final ReactiveAuthenticationManager authenticationManager;
    private int order;
    private PayloadExchangeAuthenticationConverter authenticationConverter = new BasicAuthenticationPayloadExchangeConverter();

    public AuthenticationPayloadInterceptor(ReactiveAuthenticationManager authenticationManager) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        this.authenticationManager = authenticationManager;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setAuthenticationConverter(PayloadExchangeAuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
    }

    @Override
    public Mono<Void> intercept(PayloadExchange exchange, PayloadInterceptorChain chain) {
        return this.authenticationConverter.convert(exchange).switchIfEmpty(chain.next(exchange).then(Mono.empty())).flatMap(a -> this.authenticationManager.authenticate(a)).flatMap(a -> this.onAuthenticationSuccess(chain.next(exchange), (Authentication)a));
    }

    private Mono<Void> onAuthenticationSuccess(Mono<Void> payload, Authentication authentication) {
        return payload.contextWrite((ContextView)ReactiveSecurityContextHolder.withAuthentication((Authentication)authentication));
    }
}

