/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.rsocket.util.matcher;

import java.util.Map;
import java.util.Optional;
import org.springframework.messaging.rsocket.MetadataExtractor;
import org.springframework.security.rsocket.api.PayloadExchange;
import org.springframework.security.rsocket.util.matcher.PayloadExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.util.RouteMatcher;
import reactor.core.publisher.Mono;

public class RoutePayloadExchangeMatcher
implements PayloadExchangeMatcher {
    private final String pattern;
    private final MetadataExtractor metadataExtractor;
    private final RouteMatcher routeMatcher;

    public RoutePayloadExchangeMatcher(MetadataExtractor metadataExtractor, RouteMatcher routeMatcher, String pattern) {
        Assert.notNull((Object)pattern, (String)"pattern cannot be null");
        this.metadataExtractor = metadataExtractor;
        this.routeMatcher = routeMatcher;
        this.pattern = pattern;
    }

    @Override
    public Mono<PayloadExchangeMatcher.MatchResult> matches(PayloadExchange exchange) {
        Map metadata = this.metadataExtractor.extract(exchange.getPayload(), exchange.getMetadataMimeType());
        return Optional.ofNullable((String)metadata.get("route")).map(routeValue -> this.routeMatcher.parseRoute(routeValue)).map(route -> this.routeMatcher.matchAndExtract(this.pattern, route)).map(v -> PayloadExchangeMatcher.MatchResult.match(v)).orElse(PayloadExchangeMatcher.MatchResult.notMatch());
    }
}

