/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.Transient;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.util.Assert;

@Transient
public class BearerTokenAuthentication
extends AbstractOAuth2TokenAuthenticationToken<OAuth2AccessToken> {
    private static final long serialVersionUID = 620L;
    private final Map<String, Object> attributes;

    public BearerTokenAuthentication(OAuth2AuthenticatedPrincipal principal, OAuth2AccessToken credentials, Collection<? extends GrantedAuthority> authorities) {
        super(credentials, principal, credentials, authorities);
        Assert.isTrue((credentials.getTokenType() == OAuth2AccessToken.TokenType.BEARER ? 1 : 0) != 0, (String)"credentials must be a bearer token");
        this.attributes = Collections.unmodifiableMap(new LinkedHashMap(principal.getAttributes()));
        this.setAuthenticated(true);
    }

    protected BearerTokenAuthentication(Builder<?> builder) {
        super(builder);
        this.attributes = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(builder.attributes));
    }

    @Override
    public Map<String, Object> getTokenAttributes() {
        return this.attributes;
    }

    public Builder<?> toBuilder() {
        return new Builder(this);
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOAuth2TokenAuthenticationToken.AbstractOAuth2TokenAuthenticationBuilder<OAuth2AccessToken, B> {
        private Map<String, Object> attributes;

        protected Builder(BearerTokenAuthentication token) {
            super(token);
            this.attributes = token.getTokenAttributes();
        }

        @Override
        public B principal(@Nullable Object principal) {
            Assert.isInstanceOf(OAuth2AuthenticatedPrincipal.class, (Object)principal, (String)"principal must be of type OAuth2AuthenticatedPrincipal");
            this.attributes = ((OAuth2AuthenticatedPrincipal)principal).getAttributes();
            return (B)((Object)((Builder)((Object)super.principal(principal))));
        }

        @Override
        public B credentials(@Nullable Object token) {
            Assert.isInstanceOf(OAuth2AccessToken.class, (Object)token, (String)"token must be of type OAuth2AccessToken");
            return this.token((OAuth2AccessToken)token);
        }

        @Override
        public B token(OAuth2AccessToken token) {
            Assert.isTrue((token.getTokenType() == OAuth2AccessToken.TokenType.BEARER ? 1 : 0) != 0, (String)"token must be a bearer token");
            super.credentials(token);
            return (B)((Object)((Builder)((Object)super.token(token))));
        }

        public BearerTokenAuthentication build() {
            return new BearerTokenAuthentication(this);
        }
    }
}

