/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.util.Assert;

public final class JwtIssuerValidator
implements OAuth2TokenValidator<Jwt> {
    private final JwtClaimValidator<String> validator;

    public JwtIssuerValidator(String issuer) {
        Assert.notNull((Object)issuer, (String)"issuer cannot be null");
        this.validator = new JwtClaimValidator<Object>("iss", issuer::equals);
    }

    public OAuth2TokenValidatorResult validate(Jwt token) {
        Assert.notNull((Object)token, (String)"token cannot be null");
        return this.validator.validate(token);
    }
}

