/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.core.converter.ClaimConversionService;
import org.springframework.security.oauth2.core.converter.ClaimTypeConverter;
import org.springframework.util.Assert;

public final class MappedJwtClaimSetConverter
implements Converter<Map<String, Object>, Map<String, Object>> {
    private static final ConversionService CONVERSION_SERVICE = ClaimConversionService.getSharedInstance();
    private static final TypeDescriptor OBJECT_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Object.class);
    private static final TypeDescriptor STRING_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(String.class);
    private static final TypeDescriptor INSTANT_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Instant.class);
    private static final TypeDescriptor URL_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(URL.class);
    private final Map<String, Converter<Object, ?>> claimTypeConverters;
    private final Converter<Map<String, Object>, Map<String, Object>> delegate;

    public MappedJwtClaimSetConverter(Map<String, Converter<Object, ?>> claimTypeConverters) {
        Assert.notNull(claimTypeConverters, (String)"claimTypeConverters cannot be null");
        this.claimTypeConverters = claimTypeConverters;
        this.delegate = new ClaimTypeConverter(claimTypeConverters);
    }

    public static MappedJwtClaimSetConverter withDefaults(Map<String, Converter<Object, ?>> claimTypeConverters) {
        Assert.notNull(claimTypeConverters, (String)"claimTypeConverters cannot be null");
        Converter<Object, ?> stringConverter = MappedJwtClaimSetConverter.getConverter(STRING_TYPE_DESCRIPTOR);
        Converter<Object, ?> collectionStringConverter = MappedJwtClaimSetConverter.getConverter(TypeDescriptor.collection(Collection.class, (TypeDescriptor)STRING_TYPE_DESCRIPTOR));
        HashMap claimNameToConverter = new HashMap();
        claimNameToConverter.put("aud", collectionStringConverter);
        claimNameToConverter.put("exp", MappedJwtClaimSetConverter::convertInstant);
        claimNameToConverter.put("iat", MappedJwtClaimSetConverter::convertInstant);
        claimNameToConverter.put("iss", MappedJwtClaimSetConverter::convertIssuer);
        claimNameToConverter.put("jti", stringConverter);
        claimNameToConverter.put("nbf", MappedJwtClaimSetConverter::convertInstant);
        claimNameToConverter.put("sub", stringConverter);
        claimNameToConverter.putAll(claimTypeConverters);
        return new MappedJwtClaimSetConverter(claimNameToConverter);
    }

    private static Converter<Object, ?> getConverter(TypeDescriptor targetDescriptor) {
        return source -> CONVERSION_SERVICE.convert(source, OBJECT_TYPE_DESCRIPTOR, targetDescriptor);
    }

    private static Instant convertInstant(Object source) {
        if (source == null) {
            return null;
        }
        Instant result = (Instant)CONVERSION_SERVICE.convert(source, OBJECT_TYPE_DESCRIPTOR, INSTANT_TYPE_DESCRIPTOR);
        if (result == null) {
            throw new IllegalStateException("Could not coerce " + source + " into an Instant");
        }
        return result;
    }

    private static String convertIssuer(Object source) {
        if (source == null) {
            return null;
        }
        URL result = (URL)CONVERSION_SERVICE.convert(source, OBJECT_TYPE_DESCRIPTOR, URL_TYPE_DESCRIPTOR);
        if (result != null) {
            return result.toExternalForm();
        }
        if (source instanceof String && ((String)source).contains(":")) {
            try {
                return new URI((String)source).toString();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Could not coerce " + source + " into a URI String", ex);
            }
        }
        return (String)CONVERSION_SERVICE.convert(source, OBJECT_TYPE_DESCRIPTOR, STRING_TYPE_DESCRIPTOR);
    }

    public Map<String, Object> convert(Map<String, Object> claims) {
        Assert.notNull(claims, (String)"claims cannot be null");
        Map<String, Object> mappedClaims = (Map<String, Object>)this.delegate.convert(claims);
        mappedClaims = this.removeClaims(mappedClaims);
        mappedClaims = this.addClaims(mappedClaims);
        Instant issuedAt = (Instant)mappedClaims.get("iat");
        Instant expiresAt = (Instant)mappedClaims.get("exp");
        if (issuedAt == null && expiresAt != null) {
            mappedClaims.put("iat", expiresAt.minusSeconds(1L));
        }
        return mappedClaims;
    }

    private Map<String, Object> removeClaims(Map<String, Object> claims) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : claims.entrySet()) {
            if (entry.getValue() == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private Map<String, Object> addClaims(Map<String, Object> claims) {
        HashMap<String, Object> result = new HashMap<String, Object>(claims);
        for (Map.Entry<String, Converter<Object, ?>> entry : this.claimTypeConverters.entrySet()) {
            if (claims.containsKey(entry.getKey()) || entry.getValue().convert(null) == null) continue;
            result.put(entry.getKey(), entry.getValue().convert(null));
        }
        return result;
    }
}

