/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.userinfo;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequestUtils;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserSource;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.userinfo.DefaultOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.converter.ClaimConversionService;
import org.springframework.security.oauth2.core.converter.ClaimTypeConverter;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.util.Assert;

public class OidcUserService
implements OAuth2UserService<OidcUserRequest, OidcUser> {
    private static final String INVALID_USER_INFO_RESPONSE_ERROR_CODE = "invalid_user_info_response";
    private static final Converter<Map<String, Object>, Map<String, Object>> DEFAULT_CLAIM_TYPE_CONVERTER = new ClaimTypeConverter(OidcUserService.createDefaultClaimTypeConverters());
    private OAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService = new DefaultOAuth2UserService();
    private Function<ClientRegistration, Converter<Map<String, Object>, Map<String, Object>>> claimTypeConverterFactory = clientRegistration -> DEFAULT_CLAIM_TYPE_CONVERTER;
    private Predicate<OidcUserRequest> retrieveUserInfo = OidcUserRequestUtils::shouldRetrieveUserInfo;
    private Converter<OidcUserSource, OidcUser> oidcUserConverter = OidcUserRequestUtils::getUser;

    public static Map<String, Converter<Object, ?>> createDefaultClaimTypeConverters() {
        Converter<Object, ?> booleanConverter = OidcUserService.getConverter(TypeDescriptor.valueOf(Boolean.class));
        Converter<Object, ?> instantConverter = OidcUserService.getConverter(TypeDescriptor.valueOf(Instant.class));
        HashMap claimTypeConverters = new HashMap();
        claimTypeConverters.put("email_verified", booleanConverter);
        claimTypeConverters.put("phone_number_verified", booleanConverter);
        claimTypeConverters.put("updated_at", instantConverter);
        return claimTypeConverters;
    }

    private static Converter<Object, ?> getConverter(TypeDescriptor targetDescriptor) {
        TypeDescriptor sourceDescriptor = TypeDescriptor.valueOf(Object.class);
        return source -> ClaimConversionService.getSharedInstance().convert(source, sourceDescriptor, targetDescriptor);
    }

    @Override
    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        Assert.notNull((Object)userRequest, (String)"userRequest cannot be null");
        OidcUserInfo userInfo = null;
        OAuth2User oauth2User = null;
        if (this.retrieveUserInfo.test(userRequest)) {
            oauth2User = this.oauth2UserService.loadUser(userRequest);
            Map<String, Object> claims = this.getClaims(userRequest, oauth2User);
            userInfo = new OidcUserInfo(claims);
            if (userInfo.getSubject() == null) {
                OAuth2Error oauth2Error = new OAuth2Error(INVALID_USER_INFO_RESPONSE_ERROR_CODE);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            if (!userInfo.getSubject().equals(userRequest.getIdToken().getSubject())) {
                OAuth2Error oauth2Error = new OAuth2Error(INVALID_USER_INFO_RESPONSE_ERROR_CODE);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
        }
        OidcUserSource source = new OidcUserSource(userRequest, userInfo, oauth2User);
        return (OidcUser)this.oidcUserConverter.convert((Object)source);
    }

    private Map<String, Object> getClaims(OidcUserRequest userRequest, OAuth2User oauth2User) {
        Converter<Map<String, Object>, Map<String, Object>> converter = this.claimTypeConverterFactory.apply(userRequest.getClientRegistration());
        if (converter != null) {
            return (Map)converter.convert((Object)oauth2User.getAttributes());
        }
        return (Map)DEFAULT_CLAIM_TYPE_CONVERTER.convert((Object)oauth2User.getAttributes());
    }

    public final void setOauth2UserService(OAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService) {
        Assert.notNull(oauth2UserService, (String)"oauth2UserService cannot be null");
        this.oauth2UserService = oauth2UserService;
    }

    public final void setClaimTypeConverterFactory(Function<ClientRegistration, Converter<Map<String, Object>, Map<String, Object>>> claimTypeConverterFactory) {
        Assert.notNull(claimTypeConverterFactory, (String)"claimTypeConverterFactory cannot be null");
        this.claimTypeConverterFactory = claimTypeConverterFactory;
    }

    public final void setRetrieveUserInfo(Predicate<OidcUserRequest> retrieveUserInfo) {
        Assert.notNull(retrieveUserInfo, (String)"retrieveUserInfo cannot be null");
        this.retrieveUserInfo = retrieveUserInfo;
    }

    public void setOidcUserConverter(Converter<OidcUserSource, OidcUser> oidcUserConverter) {
        Assert.notNull(oidcUserConverter, (String)"oidcUserConverter cannot be null");
        this.oidcUserConverter = oidcUserConverter;
    }
}

