/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.jackson;

import java.util.Collection;
import org.springframework.security.oauth2.client.jackson.JsonNodeUtils;
import org.springframework.security.oauth2.client.jackson.StdConverters;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthenticationMethod;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.util.StdConverter;

final class ClientRegistrationDeserializer
extends ValueDeserializer<ClientRegistration> {
    private static final StdConverter<JsonNode, ClientAuthenticationMethod> CLIENT_AUTHENTICATION_METHOD_CONVERTER = new StdConverters.ClientAuthenticationMethodConverter();
    private static final StdConverter<JsonNode, AuthorizationGrantType> AUTHORIZATION_GRANT_TYPE_CONVERTER = new StdConverters.AuthorizationGrantTypeConverter();
    private static final StdConverter<JsonNode, AuthenticationMethod> AUTHENTICATION_METHOD_CONVERTER = new StdConverters.AuthenticationMethodConverter();

    ClientRegistrationDeserializer() {
    }

    public ClientRegistration deserialize(JsonParser parser, DeserializationContext context) {
        JsonNode clientRegistrationNode = context.readTree(parser);
        JsonNode providerDetailsNode = JsonNodeUtils.findObjectNode(clientRegistrationNode, "providerDetails");
        JsonNode userInfoEndpointNode = JsonNodeUtils.findObjectNode(providerDetailsNode, "userInfoEndpoint");
        return ClientRegistration.withRegistrationId(JsonNodeUtils.findStringValue(clientRegistrationNode, "registrationId")).clientId(JsonNodeUtils.findStringValue(clientRegistrationNode, "clientId")).clientSecret(JsonNodeUtils.findStringValue(clientRegistrationNode, "clientSecret")).clientAuthenticationMethod((ClientAuthenticationMethod)CLIENT_AUTHENTICATION_METHOD_CONVERTER.convert((Object)JsonNodeUtils.findObjectNode(clientRegistrationNode, "clientAuthenticationMethod"))).authorizationGrantType((AuthorizationGrantType)AUTHORIZATION_GRANT_TYPE_CONVERTER.convert((Object)JsonNodeUtils.findObjectNode(clientRegistrationNode, "authorizationGrantType"))).redirectUri(JsonNodeUtils.findStringValue(clientRegistrationNode, "redirectUri")).scope((Collection<String>)JsonNodeUtils.findValue(clientRegistrationNode, "scopes", JsonNodeUtils.STRING_SET, context)).clientName(JsonNodeUtils.findStringValue(clientRegistrationNode, "clientName")).authorizationUri(JsonNodeUtils.findStringValue(providerDetailsNode, "authorizationUri")).tokenUri(JsonNodeUtils.findStringValue(providerDetailsNode, "tokenUri")).userInfoUri(JsonNodeUtils.findStringValue(userInfoEndpointNode, "uri")).userInfoAuthenticationMethod((AuthenticationMethod)AUTHENTICATION_METHOD_CONVERTER.convert((Object)JsonNodeUtils.findObjectNode(userInfoEndpointNode, "authenticationMethod"))).userNameAttributeName(JsonNodeUtils.findStringValue(userInfoEndpointNode, "userNameAttributeName")).jwkSetUri(JsonNodeUtils.findStringValue(providerDetailsNode, "jwkSetUri")).issuerUri(JsonNodeUtils.findStringValue(providerDetailsNode, "issuerUri")).providerConfigurationMetadata(JsonNodeUtils.findValue(providerDetailsNode, "configurationMetadata", JsonNodeUtils.STRING_OBJECT_MAP, context)).build();
    }
}

