/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.userinfo;

import java.util.LinkedHashSet;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserSource;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.util.StringUtils;

final class OidcUserRequestUtils {
    static boolean shouldRetrieveUserInfo(OidcUserRequest userRequest) {
        ClientRegistration.ProviderDetails providerDetails = userRequest.getClientRegistration().getProviderDetails();
        return StringUtils.hasLength((String)providerDetails.getUserInfoEndpoint().getUri()) && AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)userRequest.getClientRegistration().getAuthorizationGrantType());
    }

    static OidcUser getUser(OidcUserSource userMetadata) {
        OidcUserRequest userRequest = userMetadata.getUserRequest();
        OidcUserInfo userInfo = userMetadata.getUserInfo();
        LinkedHashSet<Object> authorities = new LinkedHashSet<Object>();
        ClientRegistration.ProviderDetails providerDetails = userRequest.getClientRegistration().getProviderDetails();
        String userNameAttributeName = providerDetails.getUserInfoEndpoint().getUserNameAttributeName();
        if (StringUtils.hasText((String)userNameAttributeName)) {
            authorities.add(new OidcUserAuthority(userRequest.getIdToken(), userInfo, userNameAttributeName));
        } else {
            authorities.add(new OidcUserAuthority(userRequest.getIdToken(), userInfo));
        }
        OAuth2AccessToken token = userRequest.getAccessToken();
        for (String scope : token.getScopes()) {
            authorities.add(new SimpleGrantedAuthority("SCOPE_" + scope));
        }
        if (StringUtils.hasText((String)userNameAttributeName)) {
            return new DefaultOidcUser(authorities, userRequest.getIdToken(), userInfo, userNameAttributeName);
        }
        return new DefaultOidcUser(authorities, userRequest.getIdToken(), userInfo);
    }

    private OidcUserRequestUtils() {
    }
}

