/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.util.Collections;
import java.util.Set;
import org.springframework.security.oauth2.client.endpoint.AbstractWebClientReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationExchange;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponse;
import org.springframework.web.reactive.function.BodyInserters;

public class WebClientReactiveAuthorizationCodeTokenResponseClient
extends AbstractWebClientReactiveOAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> {
    @Override
    ClientRegistration clientRegistration(OAuth2AuthorizationCodeGrantRequest grantRequest) {
        return grantRequest.getClientRegistration();
    }

    @Override
    Set<String> scopes(OAuth2AuthorizationCodeGrantRequest grantRequest) {
        return Collections.emptySet();
    }

    @Override
    BodyInserters.FormInserter<String> populateTokenRequestBody(OAuth2AuthorizationCodeGrantRequest grantRequest, BodyInserters.FormInserter<String> body) {
        String codeVerifier;
        super.populateTokenRequestBody(grantRequest, body);
        OAuth2AuthorizationExchange authorizationExchange = grantRequest.getAuthorizationExchange();
        OAuth2AuthorizationResponse authorizationResponse = authorizationExchange.getAuthorizationResponse();
        body.with("code", (Object)authorizationResponse.getCode());
        String redirectUri = authorizationExchange.getAuthorizationRequest().getRedirectUri();
        if (redirectUri != null) {
            body.with("redirect_uri", (Object)redirectUri);
        }
        if ((codeVerifier = (String)authorizationExchange.getAuthorizationRequest().getAttribute("code_verifier")) != null) {
            body.with("code_verifier", (Object)codeVerifier);
        }
        return body;
    }
}

