/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.reactive.result.method.annotation;

import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.annotation.RegisteredOAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class OAuth2AuthorizedClientArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final AnonymousAuthenticationToken ANONYMOUS_USER_TOKEN = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}));
    private ReactiveOAuth2AuthorizedClientManager authorizedClientManager;

    public OAuth2AuthorizedClientArgumentResolver(ReactiveOAuth2AuthorizedClientManager authorizedClientManager) {
        Assert.notNull((Object)authorizedClientManager, (String)"authorizedClientManager cannot be null");
        this.authorizedClientManager = authorizedClientManager;
    }

    public OAuth2AuthorizedClientArgumentResolver(ReactiveClientRegistrationRepository clientRegistrationRepository, ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        Assert.notNull((Object)authorizedClientRepository, (String)"authorizedClientRepository cannot be null");
        this.authorizedClientManager = OAuth2AuthorizedClientArgumentResolver.createDefaultAuthorizedClientManager(clientRegistrationRepository, authorizedClientRepository);
    }

    private static ReactiveOAuth2AuthorizedClientManager createDefaultAuthorizedClientManager(ReactiveClientRegistrationRepository clientRegistrationRepository, ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
        ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = ReactiveOAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().refreshToken().clientCredentials().password().build();
        DefaultReactiveOAuth2AuthorizedClientManager authorizedClientManager = new DefaultReactiveOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientRepository);
        authorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
        return authorizedClientManager;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)parameter.getParameter(), RegisteredOAuth2AuthorizedClient.class) != null;
    }

    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext bindingContext, ServerWebExchange exchange) {
        return Mono.defer(() -> {
            RegisteredOAuth2AuthorizedClient authorizedClientAnnotation = (RegisteredOAuth2AuthorizedClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)parameter.getParameter(), RegisteredOAuth2AuthorizedClient.class);
            String clientRegistrationId = StringUtils.hasLength((String)authorizedClientAnnotation.registrationId()) ? authorizedClientAnnotation.registrationId() : null;
            return this.authorizeRequest(clientRegistrationId, exchange).flatMap(this.authorizedClientManager::authorize);
        });
    }

    private Mono<OAuth2AuthorizeRequest> authorizeRequest(String registrationId, ServerWebExchange exchange) {
        Mono<Authentication> defaultedAuthentication = this.currentAuthentication();
        Mono defaultedRegistrationId = Mono.justOrEmpty((Object)registrationId).switchIfEmpty(this.clientRegistrationId(defaultedAuthentication)).switchIfEmpty(Mono.error(() -> new IllegalArgumentException("The clientRegistrationId could not be resolved. Please provide one")));
        Mono defaultedExchange = Mono.justOrEmpty((Object)exchange).switchIfEmpty(this.currentServerWebExchange());
        return Mono.zip((Mono)defaultedRegistrationId, defaultedAuthentication, (Mono)defaultedExchange).map(t3 -> {
            OAuth2AuthorizeRequest.Builder builder = OAuth2AuthorizeRequest.withClientRegistrationId((String)t3.getT1()).principal((Authentication)t3.getT2());
            if (t3.getT3() != null) {
                builder.attribute(ServerWebExchange.class.getName(), t3.getT3());
            }
            return builder.build();
        });
    }

    private Mono<Authentication> currentAuthentication() {
        return ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).defaultIfEmpty((Object)ANONYMOUS_USER_TOKEN);
    }

    private Mono<String> clientRegistrationId(Mono<Authentication> authentication) {
        return authentication.filter(t -> t instanceof OAuth2AuthenticationToken).cast(OAuth2AuthenticationToken.class).map(OAuth2AuthenticationToken::getAuthorizedClientRegistrationId);
    }

    private Mono<ServerWebExchange> currentServerWebExchange() {
        return Mono.subscriberContext().filter(c -> c.hasKey(ServerWebExchange.class)).map(c -> (ServerWebExchange)c.get(ServerWebExchange.class));
    }
}

