/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web;

import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

class OAuth2AuthorizationRequestUriBuilder {
    OAuth2AuthorizationRequestUriBuilder() {
    }

    URI build(OAuth2AuthorizationRequest authorizationRequest) {
        Assert.notNull((Object)authorizationRequest, (String)"authorizationRequest cannot be null");
        Set scopes = authorizationRequest.getScopes();
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)authorizationRequest.getAuthorizationUri()).queryParam("response_type", new Object[]{authorizationRequest.getResponseType().getValue()}).queryParam("client_id", new Object[]{authorizationRequest.getClientId()}).queryParam("scope", new Object[]{StringUtils.collectionToDelimitedString((Collection)scopes, (String)" ")}).queryParam("state", new Object[]{authorizationRequest.getState()});
        if (authorizationRequest.getRedirectUri() != null) {
            uriBuilder.queryParam("redirect_uri", new Object[]{authorizationRequest.getRedirectUri()});
        }
        return uriBuilder.build().encode().toUri();
    }
}

