/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.util.matcher;

import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.security.messaging.util.matcher.MessageMatcher;
import org.springframework.security.messaging.util.matcher.SimpMessageTypeMatcher;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpDestinationMessageMatcher
implements MessageMatcher<Object> {
    public static final MessageMatcher<Object> NULL_DESTINATION_MATCHER = new MessageMatcher<Object>(){

        @Override
        public boolean matches(Message<? extends Object> message) {
            String destination = SimpMessageHeaderAccessor.getDestination((Map)message.getHeaders());
            return destination == null;
        }
    };
    private final PathMatcher matcher;
    private final MessageMatcher<Object> messageTypeMatcher;
    private final String pattern;

    public SimpDestinationMessageMatcher(String pattern) {
        this(pattern, (PathMatcher)new AntPathMatcher());
    }

    public SimpDestinationMessageMatcher(String pattern, PathMatcher pathMatcher) {
        this(pattern, null, pathMatcher);
    }

    private SimpDestinationMessageMatcher(String pattern, SimpMessageType type, PathMatcher pathMatcher) {
        Assert.notNull((Object)pattern, (String)"pattern cannot be null");
        Assert.notNull((Object)pathMatcher, (String)"pathMatcher cannot be null");
        if (!this.isTypeWithDestination(type)) {
            throw new IllegalArgumentException("SimpMessageType " + type + " does not contain a destination and so cannot be matched on.");
        }
        this.matcher = pathMatcher;
        this.messageTypeMatcher = type == null ? ANY_MESSAGE : new SimpMessageTypeMatcher(type);
        this.pattern = pattern;
    }

    @Override
    public boolean matches(Message<? extends Object> message) {
        if (!this.messageTypeMatcher.matches(message)) {
            return false;
        }
        String destination = SimpMessageHeaderAccessor.getDestination((Map)message.getHeaders());
        return destination != null && this.matcher.match(this.pattern, destination);
    }

    public MessageMatcher<Object> getMessageTypeMatcher() {
        return this.messageTypeMatcher;
    }

    public String toString() {
        return "SimpDestinationMessageMatcher [matcher=" + this.matcher + ", messageTypeMatcher=" + this.messageTypeMatcher + ", pattern=" + this.pattern + "]";
    }

    private boolean isTypeWithDestination(SimpMessageType type) {
        if (type == null) {
            return true;
        }
        return SimpMessageType.MESSAGE.equals((Object)type) || SimpMessageType.SUBSCRIBE.equals((Object)type);
    }

    public static SimpDestinationMessageMatcher createSubscribeMatcher(String pattern, PathMatcher matcher) {
        return new SimpDestinationMessageMatcher(pattern, SimpMessageType.SUBSCRIBE, matcher);
    }

    public static SimpDestinationMessageMatcher createMessageMatcher(String pattern, PathMatcher matcher) {
        return new SimpDestinationMessageMatcher(pattern, SimpMessageType.MESSAGE, matcher);
    }
}

