/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.access.expression;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.expression.Expression;
import org.springframework.messaging.Message;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.messaging.access.expression.DefaultMessageSecurityExpressionHandler;
import org.springframework.security.messaging.access.expression.MessageExpressionConfigAttribute;
import org.springframework.security.messaging.access.intercept.DefaultMessageSecurityMetadataSource;
import org.springframework.security.messaging.access.intercept.MessageSecurityMetadataSource;
import org.springframework.security.messaging.util.matcher.MessageMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpressionBasedMessageSecurityMetadataSourceFactory {
    public static MessageSecurityMetadataSource createExpressionMessageMetadataSource(LinkedHashMap<MessageMatcher<?>, String> matcherToExpression) {
        return ExpressionBasedMessageSecurityMetadataSourceFactory.createExpressionMessageMetadataSource(matcherToExpression, new DefaultMessageSecurityExpressionHandler());
    }

    public static MessageSecurityMetadataSource createExpressionMessageMetadataSource(LinkedHashMap<MessageMatcher<?>, String> matcherToExpression, SecurityExpressionHandler<Message<Object>> handler) {
        LinkedHashMap matcherToAttrs = new LinkedHashMap();
        for (Map.Entry<MessageMatcher<?>, String> entry : matcherToExpression.entrySet()) {
            MessageMatcher<?> matcher = entry.getKey();
            String rawExpression = entry.getValue();
            Expression expression = handler.getExpressionParser().parseExpression(rawExpression);
            MessageExpressionConfigAttribute attribute = new MessageExpressionConfigAttribute(expression);
            matcherToAttrs.put(matcher, Arrays.asList(attribute));
        }
        return new DefaultMessageSecurityMetadataSource(matcherToAttrs);
    }

    private ExpressionBasedMessageSecurityMetadataSourceFactory() {
    }
}

