/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.authentication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.security.crypto.keygen.KeyGenerators;
import org.springframework.security.crypto.password.LdapShaPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticator;
import org.springframework.util.Assert;

public final class PasswordComparisonAuthenticator
extends AbstractLdapAuthenticator {
    private static final Log logger = LogFactory.getLog(PasswordComparisonAuthenticator.class);
    private PasswordEncoder passwordEncoder = new LdapShaPasswordEncoder(KeyGenerators.shared((int)0));
    private String passwordAttributeName = "userPassword";
    private boolean usePasswordAttrCompare = false;

    public PasswordComparisonAuthenticator(BaseLdapPathContextSource contextSource) {
        super((ContextSource)contextSource);
    }

    @Override
    public DirContextOperations authenticate(Authentication authentication) {
        Assert.isInstanceOf(UsernamePasswordAuthenticationToken.class, (Object)authentication, (String)"Can only process UsernamePasswordAuthenticationToken objects");
        DirContextOperations user = null;
        String username = authentication.getName();
        String password = (String)authentication.getCredentials();
        SpringSecurityLdapTemplate ldapTemplate = new SpringSecurityLdapTemplate(this.getContextSource());
        for (String userDn : this.getUserDns(username)) {
            try {
                user = ldapTemplate.retrieveEntry(userDn, this.getUserAttributes());
            }
            catch (NameNotFoundException ignore) {
                logger.trace((Object)LogMessage.format((String)"Failed to retrieve user with %s", (Object)userDn), (Throwable)ignore);
            }
            if (user == null) continue;
            break;
        }
        if (user == null) {
            logger.debug((Object)LogMessage.of(() -> "Failed to retrieve user with any user DNs " + String.valueOf(this.getUserDns(username))));
        }
        if (user == null && this.getUserSearch() != null) {
            logger.trace((Object)("Searching for user using " + String.valueOf(this.getUserSearch())));
            user = this.getUserSearch().searchForUser(username);
            if (user == null) {
                logger.debug((Object)("Failed to find user using " + String.valueOf(this.getUserSearch())));
            }
        }
        if (user == null) {
            throw UsernameNotFoundException.fromUsername((String)username);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)LogMessage.format((String)"Comparing password attribute '%s' for user '%s'", (Object)this.passwordAttributeName, (Object)user.getDn()));
        }
        if (this.usePasswordAttrCompare && this.isPasswordAttrCompare(user, password)) {
            logger.debug((Object)LogMessage.format((String)"Locally matched password attribute '%s' for user '%s'", (Object)this.passwordAttributeName, (Object)user.getDn()));
            return user;
        }
        if (this.isLdapPasswordCompare(user, ldapTemplate, password)) {
            logger.debug((Object)LogMessage.format((String)"LDAP-matched password attribute '%s' for user '%s'", (Object)this.passwordAttributeName, (Object)user.getDn()));
            return user;
        }
        throw new BadCredentialsException(this.messages.getMessage("PasswordComparisonAuthenticator.badCredentials", "Bad credentials"));
    }

    private boolean isPasswordAttrCompare(DirContextOperations user, String password) {
        String passwordAttrValue = this.getPassword(user);
        return this.passwordEncoder.matches((CharSequence)password, passwordAttrValue);
    }

    private String getPassword(DirContextOperations user) {
        Object passwordAttrValue = user.getObjectAttribute(this.passwordAttributeName);
        if (passwordAttrValue == null) {
            return null;
        }
        if (passwordAttrValue instanceof byte[]) {
            return new String((byte[])passwordAttrValue);
        }
        return String.valueOf(passwordAttrValue);
    }

    private boolean isLdapPasswordCompare(DirContextOperations user, SpringSecurityLdapTemplate ldapTemplate, String password) {
        String encodedPassword = this.passwordEncoder.encode((CharSequence)password);
        byte[] passwordBytes = Utf8.encode((CharSequence)encodedPassword);
        return ldapTemplate.compare(user.getDn().toString(), this.passwordAttributeName, passwordBytes);
    }

    public void setPasswordAttributeName(String passwordAttribute) {
        Assert.hasLength((String)passwordAttribute, (String)"passwordAttributeName must not be empty or null");
        this.passwordAttributeName = passwordAttribute;
    }

    public void setUsePasswordAttrCompare(boolean usePasswordAttrCompare) {
        this.usePasswordAttrCompare = usePasswordAttrCompare;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        Assert.notNull((Object)passwordEncoder, (String)"passwordEncoder must not be null.");
        this.passwordEncoder = passwordEncoder;
        this.setUsePasswordAttrCompare(true);
    }
}

