/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.data.repository.query;

import org.springframework.data.spel.spi.EvaluationContextExtension;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.DenyAllPermissionEvaluator;
import org.springframework.security.access.expression.SecurityExpressionRoot;
import org.springframework.security.access.hierarchicalroles.NullRoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.util.Assert;

public class SecurityEvaluationContextExtension
implements EvaluationContextExtension {
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private Authentication authentication;
    private AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();
    private RoleHierarchy roleHierarchy = new NullRoleHierarchy();
    private PermissionEvaluator permissionEvaluator = new DenyAllPermissionEvaluator();
    private String defaultRolePrefix = "ROLE_";

    public SecurityEvaluationContextExtension() {
    }

    public SecurityEvaluationContextExtension(Authentication authentication) {
        this.authentication = authentication;
    }

    public String getExtensionId() {
        return "security";
    }

    public SecurityExpressionRoot getRootObject() {
        Authentication authentication = this.getAuthentication();
        SecurityExpressionRoot root = new SecurityExpressionRoot(authentication){};
        root.setTrustResolver(this.trustResolver);
        root.setRoleHierarchy(this.roleHierarchy);
        root.setPermissionEvaluator(this.permissionEvaluator);
        root.setDefaultRolePrefix(this.defaultRolePrefix);
        return root;
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, (String)"securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    private Authentication getAuthentication() {
        if (this.authentication != null) {
            return this.authentication;
        }
        SecurityContext context = this.securityContextHolderStrategy.getContext();
        return context.getAuthentication();
    }

    public void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        Assert.notNull((Object)trustResolver, (String)"trustResolver cannot be null");
        this.trustResolver = trustResolver;
    }

    public void setRoleHierarchy(RoleHierarchy roleHierarchy) {
        Assert.notNull((Object)roleHierarchy, (String)"roleHierarchy cannot be null");
        this.roleHierarchy = roleHierarchy;
    }

    public void setPermissionEvaluator(PermissionEvaluator permissionEvaluator) {
        Assert.notNull((Object)permissionEvaluator, (String)"permissionEvaluator cannot be null");
        this.permissionEvaluator = permissionEvaluator;
    }

    public void setDefaultRolePrefix(String defaultRolePrefix) {
        this.defaultRolePrefix = defaultRolePrefix;
    }
}

