/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.server.resource;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.resource.authentication.DPoPAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.authentication.DPoPAuthenticationToken;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationEntryPointFailureHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationFilter;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.context.RequestAttributeSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

final class DPoPAuthenticationConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractHttpConfigurer<DPoPAuthenticationConfigurer<B>, B> {
    private RequestMatcher requestMatcher;
    private AuthenticationConverter authenticationConverter;
    private AuthenticationSuccessHandler authenticationSuccessHandler;
    private AuthenticationFailureHandler authenticationFailureHandler;

    DPoPAuthenticationConfigurer() {
    }

    @Override
    public void configure(B http) {
        AuthenticationManager authenticationManager = http.getSharedObject(AuthenticationManager.class);
        http.authenticationProvider((AuthenticationProvider)new DPoPAuthenticationProvider(this.getTokenAuthenticationManager(http)));
        AuthenticationFilter authenticationFilter = new AuthenticationFilter(authenticationManager, this.getAuthenticationConverter());
        authenticationFilter.setRequestMatcher(this.getRequestMatcher());
        authenticationFilter.setSuccessHandler(this.getAuthenticationSuccessHandler());
        authenticationFilter.setFailureHandler(this.getAuthenticationFailureHandler());
        authenticationFilter.setSecurityContextRepository((SecurityContextRepository)new RequestAttributeSecurityContextRepository());
        authenticationFilter = this.postProcess(authenticationFilter);
        http.addFilter((Filter)authenticationFilter);
    }

    private AuthenticationManager getTokenAuthenticationManager(B http) {
        OAuth2ResourceServerConfigurer resourceServerConfigurer = http.getConfigurer(OAuth2ResourceServerConfigurer.class);
        AuthenticationManagerResolver<HttpServletRequest> authenticationManagerResolver = resourceServerConfigurer.getAuthenticationManagerResolver();
        if (authenticationManagerResolver == null) {
            return resourceServerConfigurer.getAuthenticationManager(http);
        }
        return authentication -> {
            RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
            AuthenticationManager authenticationManager = authenticationManagerResolver.resolve((Object)servletRequestAttributes.getRequest());
            return authenticationManager.authenticate(authentication);
        };
    }

    private RequestMatcher getRequestMatcher() {
        if (this.requestMatcher == null) {
            this.requestMatcher = new DPoPRequestMatcher();
        }
        return this.requestMatcher;
    }

    private AuthenticationConverter getAuthenticationConverter() {
        if (this.authenticationConverter == null) {
            this.authenticationConverter = new DPoPAuthenticationConverter();
        }
        return this.authenticationConverter;
    }

    private AuthenticationSuccessHandler getAuthenticationSuccessHandler() {
        if (this.authenticationSuccessHandler == null) {
            this.authenticationSuccessHandler = (request, response, authentication) -> {};
        }
        return this.authenticationSuccessHandler;
    }

    private AuthenticationFailureHandler getAuthenticationFailureHandler() {
        if (this.authenticationFailureHandler == null) {
            this.authenticationFailureHandler = new AuthenticationEntryPointFailureHandler((AuthenticationEntryPoint)new DPoPAuthenticationEntryPoint());
        }
        return this.authenticationFailureHandler;
    }

    private static final class DPoPRequestMatcher
    implements RequestMatcher {
        private DPoPRequestMatcher() {
        }

        public boolean matches(HttpServletRequest request) {
            String authorization = request.getHeader("Authorization");
            if (!StringUtils.hasText((String)authorization)) {
                return false;
            }
            return StringUtils.startsWithIgnoreCase((String)authorization, (String)OAuth2AccessToken.TokenType.DPOP.getValue());
        }
    }

    private static final class DPoPAuthenticationConverter
    implements AuthenticationConverter {
        private static final Pattern AUTHORIZATION_PATTERN = Pattern.compile("^DPoP (?<token>[a-zA-Z0-9-._~+/]+=*)$", 2);

        private DPoPAuthenticationConverter() {
        }

        public Authentication convert(HttpServletRequest request) {
            ArrayList authorizationList = Collections.list(request.getHeaders("Authorization"));
            if (CollectionUtils.isEmpty(authorizationList)) {
                return null;
            }
            if (authorizationList.size() != 1) {
                OAuth2Error error = new OAuth2Error("invalid_request", "Found multiple Authorization headers.", null);
                throw new OAuth2AuthenticationException(error);
            }
            String authorization = (String)authorizationList.get(0);
            if (!StringUtils.startsWithIgnoreCase((String)authorization, (String)OAuth2AccessToken.TokenType.DPOP.getValue())) {
                return null;
            }
            Matcher matcher = AUTHORIZATION_PATTERN.matcher(authorization);
            if (!matcher.matches()) {
                OAuth2Error error = new OAuth2Error("invalid_token", "DPoP access token is malformed.", null);
                throw new OAuth2AuthenticationException(error);
            }
            String accessToken = matcher.group("token");
            ArrayList dPoPProofList = Collections.list(request.getHeaders(OAuth2AccessToken.TokenType.DPOP.getValue()));
            if (CollectionUtils.isEmpty(dPoPProofList) || dPoPProofList.size() != 1) {
                OAuth2Error error = new OAuth2Error("invalid_request", "DPoP proof is missing or invalid.", null);
                throw new OAuth2AuthenticationException(error);
            }
            String dPoPProof = (String)dPoPProofList.get(0);
            return new DPoPAuthenticationToken(accessToken, dPoPProof, request.getMethod(), request.getRequestURL().toString());
        }
    }

    private static final class DPoPAuthenticationEntryPoint
    implements AuthenticationEntryPoint {
        private DPoPAuthenticationEntryPoint() {
        }

        public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authenticationException) {
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            if (authenticationException instanceof OAuth2AuthenticationException) {
                OAuth2AuthenticationException oauth2AuthenticationException = (OAuth2AuthenticationException)((Object)authenticationException);
                OAuth2Error error = oauth2AuthenticationException.getError();
                parameters.put("error", error.getErrorCode());
                if (StringUtils.hasText((String)error.getDescription())) {
                    parameters.put("error_description", error.getDescription());
                }
                if (StringUtils.hasText((String)error.getUri())) {
                    parameters.put("error_uri", error.getUri());
                }
            }
            parameters.put("algs", "RS256 RS384 RS512 PS256 PS384 PS512 ES256 ES384 ES512");
            String wwwAuthenticate = DPoPAuthenticationEntryPoint.toWWWAuthenticateHeader(parameters);
            response.addHeader("WWW-Authenticate", wwwAuthenticate);
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
        }

        private static String toWWWAuthenticateHeader(Map<String, String> parameters) {
            StringBuilder wwwAuthenticate = new StringBuilder();
            wwwAuthenticate.append(OAuth2AccessToken.TokenType.DPOP.getValue());
            if (!parameters.isEmpty()) {
                wwwAuthenticate.append(" ");
                int i = 0;
                for (Map.Entry<String, String> entry : parameters.entrySet()) {
                    wwwAuthenticate.append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
                    if (i++ == parameters.size() - 1) continue;
                    wwwAuthenticate.append(", ");
                }
            }
            return wwwAuthenticate.toString();
        }
    }
}

