/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import jakarta.servlet.Filter;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurerUtils;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthorizationCodeAuthenticationProvider;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.AuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationCodeGrantFilter;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.util.Assert;

public final class OAuth2ClientConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractHttpConfigurer<OAuth2ClientConfigurer<B>, B> {
    private AuthorizationCodeGrantConfigurer authorizationCodeGrantConfigurer = new AuthorizationCodeGrantConfigurer();
    private ClientRegistrationRepository clientRegistrationRepository;
    private OAuth2AuthorizedClientRepository authorizedClientRepository;

    public OAuth2ClientConfigurer<B> clientRegistrationRepository(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(ClientRegistrationRepository.class, clientRegistrationRepository);
        this.clientRegistrationRepository = clientRegistrationRepository;
        return this;
    }

    public OAuth2ClientConfigurer<B> authorizedClientRepository(OAuth2AuthorizedClientRepository authorizedClientRepository) {
        Assert.notNull((Object)authorizedClientRepository, (String)"authorizedClientRepository cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(OAuth2AuthorizedClientRepository.class, authorizedClientRepository);
        this.authorizedClientRepository = authorizedClientRepository;
        return this;
    }

    public OAuth2ClientConfigurer<B> authorizedClientService(OAuth2AuthorizedClientService authorizedClientService) {
        Assert.notNull((Object)authorizedClientService, (String)"authorizedClientService cannot be null");
        this.authorizedClientRepository((OAuth2AuthorizedClientRepository)new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(authorizedClientService));
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public AuthorizationCodeGrantConfigurer authorizationCodeGrant() {
        return this.authorizationCodeGrantConfigurer;
    }

    public OAuth2ClientConfigurer<B> authorizationCodeGrant(Customizer<AuthorizationCodeGrantConfigurer> authorizationCodeGrantCustomizer) {
        authorizationCodeGrantCustomizer.customize(this.authorizationCodeGrantConfigurer);
        return this;
    }

    @Override
    public void init(B builder) {
        this.authorizationCodeGrantConfigurer.init(builder);
    }

    @Override
    public void configure(B builder) {
        this.authorizationCodeGrantConfigurer.configure(builder);
    }

    public final class AuthorizationCodeGrantConfigurer {
        private OAuth2AuthorizationRequestResolver authorizationRequestResolver;
        private AuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository;
        private RedirectStrategy authorizationRedirectStrategy;
        private OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient;

        private AuthorizationCodeGrantConfigurer() {
        }

        public AuthorizationCodeGrantConfigurer authorizationRequestResolver(OAuth2AuthorizationRequestResolver authorizationRequestResolver) {
            Assert.notNull((Object)authorizationRequestResolver, (String)"authorizationRequestResolver cannot be null");
            this.authorizationRequestResolver = authorizationRequestResolver;
            return this;
        }

        public AuthorizationCodeGrantConfigurer authorizationRequestRepository(AuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository) {
            Assert.notNull(authorizationRequestRepository, (String)"authorizationRequestRepository cannot be null");
            this.authorizationRequestRepository = authorizationRequestRepository;
            return this;
        }

        public AuthorizationCodeGrantConfigurer authorizationRedirectStrategy(RedirectStrategy authorizationRedirectStrategy) {
            this.authorizationRedirectStrategy = authorizationRedirectStrategy;
            return this;
        }

        public AuthorizationCodeGrantConfigurer accessTokenResponseClient(OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient) {
            Assert.notNull(accessTokenResponseClient, (String)"accessTokenResponseClient cannot be null");
            this.accessTokenResponseClient = accessTokenResponseClient;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public OAuth2ClientConfigurer<B> and() {
            return OAuth2ClientConfigurer.this;
        }

        private void init(B builder) {
            OAuth2AuthorizationCodeAuthenticationProvider authorizationCodeAuthenticationProvider = new OAuth2AuthorizationCodeAuthenticationProvider(this.getAccessTokenResponseClient());
            builder.authenticationProvider((AuthenticationProvider)OAuth2ClientConfigurer.this.postProcess(authorizationCodeAuthenticationProvider));
        }

        private void configure(B builder) {
            OAuth2AuthorizationRequestRedirectFilter authorizationRequestRedirectFilter = this.createAuthorizationRequestRedirectFilter(builder);
            builder.addFilter((Filter)OAuth2ClientConfigurer.this.postProcess(authorizationRequestRedirectFilter));
            OAuth2AuthorizationCodeGrantFilter authorizationCodeGrantFilter = this.createAuthorizationCodeGrantFilter(builder);
            builder.addFilter((Filter)OAuth2ClientConfigurer.this.postProcess(authorizationCodeGrantFilter));
        }

        private OAuth2AuthorizationRequestRedirectFilter createAuthorizationRequestRedirectFilter(B builder) {
            RequestCache requestCache;
            OAuth2AuthorizationRequestResolver resolver = this.getAuthorizationRequestResolver();
            OAuth2AuthorizationRequestRedirectFilter authorizationRequestRedirectFilter = new OAuth2AuthorizationRequestRedirectFilter(resolver);
            if (this.authorizationRequestRepository != null) {
                authorizationRequestRedirectFilter.setAuthorizationRequestRepository(this.authorizationRequestRepository);
            }
            if (this.authorizationRedirectStrategy != null) {
                authorizationRequestRedirectFilter.setAuthorizationRedirectStrategy(this.authorizationRedirectStrategy);
            }
            if ((requestCache = builder.getSharedObject(RequestCache.class)) != null) {
                authorizationRequestRedirectFilter.setRequestCache(requestCache);
            }
            return authorizationRequestRedirectFilter;
        }

        private OAuth2AuthorizationRequestResolver getAuthorizationRequestResolver() {
            if (this.authorizationRequestResolver != null) {
                return this.authorizationRequestResolver;
            }
            ClientRegistrationRepository clientRegistrationRepository = this.getClientRegistrationRepository((HttpSecurityBuilder)OAuth2ClientConfigurer.this.getBuilder());
            return new DefaultOAuth2AuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization");
        }

        private OAuth2AuthorizationCodeGrantFilter createAuthorizationCodeGrantFilter(B builder) {
            AuthenticationManager authenticationManager = builder.getSharedObject(AuthenticationManager.class);
            OAuth2AuthorizationCodeGrantFilter authorizationCodeGrantFilter = new OAuth2AuthorizationCodeGrantFilter(this.getClientRegistrationRepository(builder), this.getAuthorizedClientRepository(builder), authenticationManager);
            if (this.authorizationRequestRepository != null) {
                authorizationCodeGrantFilter.setAuthorizationRequestRepository(this.authorizationRequestRepository);
            }
            authorizationCodeGrantFilter.setSecurityContextHolderStrategy(OAuth2ClientConfigurer.this.getSecurityContextHolderStrategy());
            RequestCache requestCache = builder.getSharedObject(RequestCache.class);
            if (requestCache != null) {
                authorizationCodeGrantFilter.setRequestCache(requestCache);
            }
            return authorizationCodeGrantFilter;
        }

        private OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> getAccessTokenResponseClient() {
            if (this.accessTokenResponseClient != null) {
                return this.accessTokenResponseClient;
            }
            ResolvableType resolvableType = ResolvableType.forClassWithGenerics(OAuth2AccessTokenResponseClient.class, (Class[])new Class[]{OAuth2AuthorizationCodeGrantRequest.class});
            OAuth2AccessTokenResponseClient bean = (OAuth2AccessTokenResponseClient)this.getBeanOrNull(resolvableType);
            return bean != null ? bean : new DefaultAuthorizationCodeTokenResponseClient();
        }

        private ClientRegistrationRepository getClientRegistrationRepository(B builder) {
            return OAuth2ClientConfigurer.this.clientRegistrationRepository != null ? OAuth2ClientConfigurer.this.clientRegistrationRepository : OAuth2ClientConfigurerUtils.getClientRegistrationRepository(builder);
        }

        private OAuth2AuthorizedClientRepository getAuthorizedClientRepository(B builder) {
            return OAuth2ClientConfigurer.this.authorizedClientRepository != null ? OAuth2ClientConfigurer.this.authorizedClientRepository : OAuth2ClientConfigurerUtils.getAuthorizedClientRepository(builder);
        }

        private <T> T getBeanOrNull(ResolvableType type) {
            String[] names;
            ApplicationContext context = ((HttpSecurityBuilder)OAuth2ClientConfigurer.this.getBuilder()).getSharedObject(ApplicationContext.class);
            if (context != null && (names = context.getBeanNamesForType(type)).length == 1) {
                return (T)context.getBean(names[0]);
            }
            return null;
        }
    }
}

