/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.authorization.ObservationReactiveAuthorizationManager;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.authorization.method.AuthorizationManagerAfterReactiveMethodInterceptor;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeReactiveMethodInterceptor;
import org.springframework.security.authorization.method.PostAuthorizeReactiveAuthorizationManager;
import org.springframework.security.authorization.method.PostFilterAuthorizationReactiveMethodInterceptor;
import org.springframework.security.authorization.method.PreAuthorizeReactiveAuthorizationManager;
import org.springframework.security.authorization.method.PreFilterAuthorizationReactiveMethodInterceptor;
import org.springframework.security.config.core.GrantedAuthorityDefaults;

@Configuration(proxyBeanMethods=false)
final class ReactiveAuthorizationManagerMethodSecurityConfiguration {
    ReactiveAuthorizationManagerMethodSecurityConfiguration() {
    }

    @Bean
    @Role(value=2)
    static PreFilterAuthorizationReactiveMethodInterceptor preFilterInterceptor(MethodSecurityExpressionHandler expressionHandler) {
        return new PreFilterAuthorizationReactiveMethodInterceptor(expressionHandler);
    }

    @Bean
    @Role(value=2)
    static AuthorizationManagerBeforeReactiveMethodInterceptor preAuthorizeInterceptor(MethodSecurityExpressionHandler expressionHandler, ObjectProvider<ObservationRegistry> registryProvider) {
        ReactiveAuthorizationManager authorizationManager = ReactiveAuthorizationManagerMethodSecurityConfiguration.manager(new PreAuthorizeReactiveAuthorizationManager(expressionHandler), registryProvider);
        return AuthorizationManagerBeforeReactiveMethodInterceptor.preAuthorize(authorizationManager);
    }

    @Bean
    @Role(value=2)
    static PostFilterAuthorizationReactiveMethodInterceptor postFilterInterceptor(MethodSecurityExpressionHandler expressionHandler) {
        return new PostFilterAuthorizationReactiveMethodInterceptor(expressionHandler);
    }

    @Bean
    @Role(value=2)
    static AuthorizationManagerAfterReactiveMethodInterceptor postAuthorizeInterceptor(MethodSecurityExpressionHandler expressionHandler, ObjectProvider<ObservationRegistry> registryProvider) {
        ReactiveAuthorizationManager authorizationManager = ReactiveAuthorizationManagerMethodSecurityConfiguration.manager(new PostAuthorizeReactiveAuthorizationManager(expressionHandler), registryProvider);
        return AuthorizationManagerAfterReactiveMethodInterceptor.postAuthorize(authorizationManager);
    }

    @Bean
    @Role(value=2)
    static DefaultMethodSecurityExpressionHandler methodSecurityExpressionHandler(@Autowired(required=false) GrantedAuthorityDefaults grantedAuthorityDefaults) {
        DefaultMethodSecurityExpressionHandler handler = new DefaultMethodSecurityExpressionHandler();
        if (grantedAuthorityDefaults != null) {
            handler.setDefaultRolePrefix(grantedAuthorityDefaults.getRolePrefix());
        }
        return handler;
    }

    static <T> ReactiveAuthorizationManager<T> manager(ReactiveAuthorizationManager<T> delegate, ObjectProvider<ObservationRegistry> registryProvider) {
        ObservationRegistry registry = (ObservationRegistry)registryProvider.getIfAvailable(() -> ObservationRegistry.NOOP);
        if (registry.isNoop()) {
            return delegate;
        }
        return new ObservationReactiveAuthorizationManager(registry, delegate);
    }
}

