/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.util.ClassUtils;

public class SerializationUtils {
    private static final List<String> ALLOWED_CLASSES;

    public static byte[] serialize(Object state) {
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(512);
            oos = new ObjectOutputStream(bos);
            oos.writeObject(state);
            oos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static <T> T deserialize(byte[] byteArray) {
        Object object;
        ObjectInputStream oip = null;
        try {
            Object result;
            oip = new SaferObjectInputStream(new ByteArrayInputStream(byteArray), Thread.currentThread().getContextClassLoader(), ALLOWED_CLASSES);
            object = result = oip.readObject();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (oip != null) {
                try {
                    oip.close();
                }
                catch (IOException iOException) {}
            }
        }
        return (T)object;
    }

    static {
        ArrayList<String> classes = new ArrayList<String>();
        classes.add("java.lang.");
        classes.add("java.util.");
        classes.add("org.springframework.security.");
        ALLOWED_CLASSES = Collections.unmodifiableList(classes);
    }

    private static class SaferObjectInputStream
    extends ObjectInputStream {
        private final List<String> allowedClasses;
        private final ClassLoader classLoader;

        SaferObjectInputStream(InputStream in, ClassLoader classLoader, List<String> allowedClasses) throws IOException {
            super(in);
            this.classLoader = classLoader;
            this.allowedClasses = Collections.unmodifiableList(allowedClasses);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            if (this.isProhibited(classDesc.getName())) {
                throw new NotSerializableException("Not allowed to deserialize " + classDesc.getName());
            }
            if (this.classLoader != null) {
                return ClassUtils.forName((String)classDesc.getName(), (ClassLoader)this.classLoader);
            }
            return super.resolveClass(classDesc);
        }

        private boolean isProhibited(String className) {
            for (String allowedClass : this.allowedClasses) {
                if (!className.startsWith(allowedClass)) continue;
                return false;
            }
            return true;
        }
    }
}

