/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.expression;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.InsufficientScopeException;
import org.springframework.security.oauth2.provider.expression.OAuth2ExpressionUtils;

public class OAuth2SecurityExpressionMethods {
    private final Authentication authentication;
    private Set<String> missingScopes = new LinkedHashSet<String>();
    private boolean throwExceptionOnInvalidScope;

    public OAuth2SecurityExpressionMethods(Authentication authentication, boolean throwExceptionOnInvalidScope) {
        this.authentication = authentication;
        this.throwExceptionOnInvalidScope = throwExceptionOnInvalidScope;
    }

    public boolean sufficientScope(boolean decision) {
        if (!decision && !this.missingScopes.isEmpty()) {
            throw new InsufficientScopeException("Insufficient scope for this resource", this.missingScopes);
        }
        return decision;
    }

    public boolean clientHasRole(String role) {
        return this.clientHasAnyRole(role);
    }

    public boolean clientHasAnyRole(String ... roles) {
        return OAuth2ExpressionUtils.clientHasAnyRole(this.authentication, roles);
    }

    public boolean hasScope(String scope) {
        return this.hasAnyScope(scope);
    }

    public boolean hasAnyScope(String ... scopes) {
        boolean result = OAuth2ExpressionUtils.hasAnyScope(this.authentication, scopes);
        if (!result && this.throwExceptionOnInvalidScope) {
            this.missingScopes.addAll(Arrays.asList(scopes));
            InsufficientScopeException failure = new InsufficientScopeException("Insufficient scope for this resource", this.missingScopes);
            throw new AccessDeniedException(failure.getMessage(), (Throwable)failure);
        }
        return result;
    }

    public boolean denyOAuthClient() {
        return !OAuth2ExpressionUtils.isOAuth(this.authentication);
    }

    public boolean isUser() {
        return OAuth2ExpressionUtils.isOAuthUserAuth(this.authentication);
    }

    public boolean isClient() {
        return OAuth2ExpressionUtils.isOAuthClientAuth(this.authentication);
    }

    public void setThrowExceptionOnInvalidScope(boolean throwExceptionOnInvalidScope) {
        this.throwExceptionOnInvalidScope = throwExceptionOnInvalidScope;
    }
}

