/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.code;

import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.AuthorizationRequestHolder;

public abstract class RandomValueAuthorizationCodeServices
implements AuthorizationCodeServices {
    private RandomValueStringGenerator generator = new RandomValueStringGenerator();

    protected abstract void store(String var1, AuthorizationRequestHolder var2);

    protected abstract AuthorizationRequestHolder remove(String var1);

    public String createAuthorizationCode(AuthorizationRequestHolder authentication) {
        String code = this.generator.generate();
        this.store(code, authentication);
        return code;
    }

    public AuthorizationRequestHolder consumeAuthorizationCode(String code) throws InvalidGrantException {
        AuthorizationRequestHolder auth = this.remove(code);
        if (auth == null) {
            throw new InvalidGrantException("Invalid authorization code: " + code);
        }
        return auth;
    }
}

