/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.token;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.ClientKeyGenerator;
import org.springframework.security.oauth2.common.util.OAuth2Utils;

public class DefaultClientKeyGenerator
implements ClientKeyGenerator {
    private static final String CLIENT_ID = "client_id";
    private static final String SCOPE = "scope";
    private static final String USERNAME = "username";

    public String extractKey(OAuth2ProtectedResourceDetails resource, Authentication authentication) {
        MessageDigest digest;
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        if (authentication != null) {
            values.put(USERNAME, authentication.getName());
        }
        values.put(CLIENT_ID, resource.getClientId());
        if (resource.getScope() != null) {
            values.put(SCOPE, OAuth2Utils.formatParameterList(resource.getScope()));
        }
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 algorithm not available.  Fatal (should be in the JDK).");
        }
        try {
            byte[] bytes = digest.digest(((Object)values).toString().getBytes("UTF-8"));
            return String.format("%032x", new BigInteger(1, bytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding not available.  Fatal (should be in the JDK).");
        }
    }
}

