/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.token;

import java.util.Collections;
import java.util.List;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.ClientTokenServices;
import org.springframework.security.oauth2.client.token.OAuth2AccessTokenSupport;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessTokenProviderChain
extends OAuth2AccessTokenSupport
implements AccessTokenProvider {
    private final List<AccessTokenProvider> chain;
    private ClientTokenServices clientTokenServices;

    public AccessTokenProviderChain(List<? extends AccessTokenProvider> chain) {
        this.chain = chain == null ? Collections.emptyList() : Collections.unmodifiableList(chain);
    }

    public void setClientTokenServices(ClientTokenServices clientTokenServices) {
        this.clientTokenServices = clientTokenServices;
    }

    @Override
    public boolean supportsResource(OAuth2ProtectedResourceDetails resource) {
        for (AccessTokenProvider tokenProvider : this.chain) {
            if (!tokenProvider.supportsResource(resource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsRefresh(OAuth2ProtectedResourceDetails resource) {
        for (AccessTokenProvider tokenProvider : this.chain) {
            if (!tokenProvider.supportsRefresh(resource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public OAuth2AccessToken obtainAccessToken(OAuth2ProtectedResourceDetails resource, AccessTokenRequest request) throws UserRedirectRequiredException, AccessDeniedException {
        OAuth2AccessToken accessToken = null;
        OAuth2AccessToken existingToken = null;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth instanceof AnonymousAuthenticationToken && !resource.isClientOnly()) {
            throw new InsufficientAuthenticationException("Authentication is required to obtain an access token (anonymous not allowed)");
        }
        if (resource.isClientOnly() || auth != null && auth.isAuthenticated()) {
            existingToken = request.getExistingToken();
            if (existingToken == null && this.clientTokenServices != null) {
                existingToken = this.clientTokenServices.getAccessToken(resource, auth);
            }
            if (existingToken != null) {
                if (existingToken.isExpired()) {
                    OAuth2RefreshToken refreshToken;
                    if (this.clientTokenServices != null) {
                        this.clientTokenServices.removeAccessToken(resource, auth);
                    }
                    if ((refreshToken = existingToken.getRefreshToken()) != null) {
                        accessToken = this.refreshAccessToken(resource, refreshToken, request);
                    }
                } else {
                    accessToken = existingToken;
                }
            }
        }
        if (accessToken == null && (accessToken = this.obtainNewAccessTokenInternal(resource, request)) == null) {
            throw new IllegalStateException("An OAuth 2 access token must be obtained or an exception thrown.");
        }
        if (this.clientTokenServices != null) {
            this.clientTokenServices.saveAccessToken(resource, auth, accessToken);
        }
        return accessToken;
    }

    protected OAuth2AccessToken obtainNewAccessTokenInternal(OAuth2ProtectedResourceDetails details, AccessTokenRequest request) throws UserRedirectRequiredException, AccessDeniedException {
        if (request.isError()) {
            throw OAuth2Exception.valueOf(request.toSingleValueMap());
        }
        for (AccessTokenProvider tokenProvider : this.chain) {
            if (!tokenProvider.supportsResource(details)) continue;
            return tokenProvider.obtainAccessToken(details, request);
        }
        throw new OAuth2AccessDeniedException("Unable to obtain a new access token for resource '" + details.getId() + "'. The provider manager is not configured to support it.", details);
    }

    @Override
    public OAuth2AccessToken refreshAccessToken(OAuth2ProtectedResourceDetails resource, OAuth2RefreshToken refreshToken, AccessTokenRequest request) throws UserRedirectRequiredException {
        for (AccessTokenProvider tokenProvider : this.chain) {
            if (!tokenProvider.supportsRefresh(resource)) continue;
            return tokenProvider.refreshAccessToken(resource, refreshToken, request);
        }
        throw new OAuth2AccessDeniedException("Unable to obtain a new access token for resource '" + resource.getId() + "'. The provider manager is not configured to support it.", resource);
    }
}

