/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.restassured;

import io.restassured.http.Cookie;
import io.restassured.http.Header;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.MultiPartSpecification;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestFactory;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.operation.OperationRequestPartFactory;
import org.springframework.restdocs.operation.RequestConverter;
import org.springframework.restdocs.operation.RequestCookie;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

class RestAssuredRequestConverter
implements RequestConverter<FilterableRequestSpecification> {
    RestAssuredRequestConverter() {
    }

    public OperationRequest convert(FilterableRequestSpecification requestSpec) {
        return new OperationRequestFactory().create(URI.create(requestSpec.getURI()), HttpMethod.valueOf((String)requestSpec.getMethod()), this.extractContent(requestSpec), this.extractHeaders(requestSpec), this.extractParts(requestSpec), this.extractCookies(requestSpec));
    }

    private Collection<RequestCookie> extractCookies(FilterableRequestSpecification requestSpec) {
        ArrayList<RequestCookie> cookies = new ArrayList<RequestCookie>();
        for (Cookie cookie : requestSpec.getCookies()) {
            cookies.add(new RequestCookie(cookie.getName(), cookie.getValue()));
        }
        return cookies;
    }

    private byte[] extractContent(FilterableRequestSpecification requestSpec) {
        Object body = requestSpec.getBody();
        if (body != null) {
            return this.convertContent(body);
        }
        StringBuilder parameters = new StringBuilder();
        if ("POST".equals(requestSpec.getMethod())) {
            this.appendParameters(parameters, requestSpec.getRequestParams());
        }
        if (!"GET".equals(requestSpec.getMethod())) {
            this.appendParameters(parameters, requestSpec.getFormParams());
        }
        return parameters.toString().getBytes(StandardCharsets.ISO_8859_1);
    }

    private void appendParameters(StringBuilder content, Map<String, ?> parameters) {
        for (Map.Entry<String, ?> entry : parameters.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Iterable) {
                for (Object v : (Iterable)value) {
                    RestAssuredRequestConverter.append(content, name, v.toString());
                }
                continue;
            }
            if (value != null) {
                RestAssuredRequestConverter.append(content, name, value.toString());
                continue;
            }
            RestAssuredRequestConverter.append(content, name);
        }
    }

    private byte[] convertContent(Object content) {
        if (content instanceof String) {
            return ((String)content).getBytes();
        }
        if (content instanceof byte[]) {
            return (byte[])content;
        }
        if (content instanceof File) {
            return this.copyToByteArray((File)content);
        }
        if (content instanceof InputStream) {
            return this.copyToByteArray((InputStream)content);
        }
        if (content == null) {
            return new byte[0];
        }
        throw new IllegalStateException("Unsupported request content: " + content.getClass().getName());
    }

    private byte[] copyToByteArray(File file) {
        try {
            return FileCopyUtils.copyToByteArray((File)file);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to read content from file " + file, ex);
        }
    }

    private byte[] copyToByteArray(InputStream inputStream) {
        try {
            inputStream.reset();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot read content from input stream " + inputStream + " due to reset() failure");
        }
        try {
            return StreamUtils.copyToByteArray((InputStream)inputStream);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to read content from input stream " + inputStream, ex);
        }
    }

    private HttpHeaders extractHeaders(FilterableRequestSpecification requestSpec) {
        HttpHeaders httpHeaders = new HttpHeaders();
        for (Header header : requestSpec.getHeaders()) {
            if (this.isAllMediaTypesAcceptHeader(header)) continue;
            httpHeaders.add(header.getName(), header.getValue());
        }
        return httpHeaders;
    }

    private boolean isAllMediaTypesAcceptHeader(Header header) {
        return "Accept".equals(header.getName()) && "*/*".equals(header.getValue());
    }

    private Collection<OperationRequestPart> extractParts(FilterableRequestSpecification requestSpec) {
        ArrayList<OperationRequestPart> parts = new ArrayList<OperationRequestPart>();
        for (MultiPartSpecification multiPartSpec : requestSpec.getMultiPartParams()) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(multiPartSpec.getMimeType() != null ? MediaType.parseMediaType((String)multiPartSpec.getMimeType()) : MediaType.TEXT_PLAIN);
            parts.add(new OperationRequestPartFactory().create(multiPartSpec.getControlName(), multiPartSpec.getFileName(), this.convertContent(multiPartSpec.getContent()), headers));
        }
        return parts;
    }

    private static void append(StringBuilder sb, String key) {
        RestAssuredRequestConverter.append(sb, key, "");
    }

    private static void append(StringBuilder sb, String key, String value) {
        RestAssuredRequestConverter.doAppend(sb, RestAssuredRequestConverter.urlEncode(key) + "=" + RestAssuredRequestConverter.urlEncode(value));
    }

    private static void doAppend(StringBuilder sb, String toAppend) {
        if (sb.length() > 0) {
            sb.append("&");
        }
        sb.append(toAppend);
    }

    private static String urlEncode(String s) {
        if (!StringUtils.hasLength((String)s)) {
            return "";
        }
        return URLEncoder.encode(s, StandardCharsets.UTF_8);
    }
}

