/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.mockmvc;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.Part;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockMultipartHttpServletRequest;
import org.springframework.restdocs.mockmvc.IterableEnumeration;
import org.springframework.restdocs.operation.ConversionException;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestFactory;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.operation.OperationRequestPartFactory;
import org.springframework.restdocs.operation.Parameters;
import org.springframework.restdocs.operation.RequestConverter;
import org.springframework.restdocs.operation.RequestCookie;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

class MockMvcRequestConverter
implements RequestConverter<MockHttpServletRequest> {
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";
    private static final int STANDARD_PORT_HTTP = 80;
    private static final int STANDARD_PORT_HTTPS = 443;

    MockMvcRequestConverter() {
    }

    public OperationRequest convert(MockHttpServletRequest mockRequest) {
        try {
            HttpHeaders headers = this.extractHeaders(mockRequest);
            Parameters parameters = this.extractParameters(mockRequest);
            List<OperationRequestPart> parts = this.extractParts(mockRequest);
            Collection<RequestCookie> cookies = this.extractCookies(mockRequest, headers);
            String queryString = mockRequest.getQueryString();
            if (!StringUtils.hasText((String)queryString) && "GET".equals(mockRequest.getMethod())) {
                queryString = parameters.toQueryString();
            }
            return new OperationRequestFactory().create(URI.create(this.getRequestUri(mockRequest) + (StringUtils.hasText((String)queryString) ? "?" + queryString : "")), HttpMethod.valueOf((String)mockRequest.getMethod()), mockRequest.getContentAsByteArray(), headers, parameters, parts, cookies);
        }
        catch (Exception ex) {
            throw new ConversionException((Throwable)ex);
        }
    }

    private Collection<RequestCookie> extractCookies(MockHttpServletRequest mockRequest, HttpHeaders headers) {
        if (mockRequest.getCookies() == null || mockRequest.getCookies().length == 0) {
            return Collections.emptyList();
        }
        ArrayList<RequestCookie> cookies = new ArrayList<RequestCookie>();
        for (Cookie servletCookie : mockRequest.getCookies()) {
            cookies.add(new RequestCookie(servletCookie.getName(), servletCookie.getValue()));
        }
        headers.remove((Object)"Cookie");
        return cookies;
    }

    private List<OperationRequestPart> extractParts(MockHttpServletRequest servletRequest) throws IOException, ServletException {
        ArrayList<OperationRequestPart> parts = new ArrayList<OperationRequestPart>();
        parts.addAll(this.extractServletRequestParts(servletRequest));
        if (servletRequest instanceof MockMultipartHttpServletRequest) {
            parts.addAll(this.extractMultipartRequestParts((MockMultipartHttpServletRequest)servletRequest));
        }
        return parts;
    }

    private List<OperationRequestPart> extractServletRequestParts(MockHttpServletRequest servletRequest) throws IOException, ServletException {
        ArrayList<OperationRequestPart> parts = new ArrayList<OperationRequestPart>();
        for (Part part : servletRequest.getParts()) {
            parts.add(this.createOperationRequestPart(part));
        }
        return parts;
    }

    private OperationRequestPart createOperationRequestPart(Part part) throws IOException {
        HttpHeaders partHeaders = this.extractHeaders(part);
        List contentTypeHeader = partHeaders.get((Object)"Content-Type");
        if (part.getContentType() != null && contentTypeHeader == null) {
            partHeaders.setContentType(MediaType.parseMediaType((String)part.getContentType()));
        }
        return new OperationRequestPartFactory().create(part.getName(), StringUtils.hasText((String)part.getSubmittedFileName()) ? part.getSubmittedFileName() : null, FileCopyUtils.copyToByteArray((InputStream)part.getInputStream()), partHeaders);
    }

    private List<OperationRequestPart> extractMultipartRequestParts(MockMultipartHttpServletRequest multipartRequest) throws IOException {
        ArrayList<OperationRequestPart> parts = new ArrayList<OperationRequestPart>();
        for (Map.Entry entry : multipartRequest.getMultiFileMap().entrySet()) {
            for (MultipartFile file : (List)entry.getValue()) {
                parts.add(this.createOperationRequestPart(file));
            }
        }
        return parts;
    }

    private OperationRequestPart createOperationRequestPart(MultipartFile file) throws IOException {
        HttpHeaders partHeaders = new HttpHeaders();
        if (StringUtils.hasText((String)file.getContentType())) {
            partHeaders.setContentType(MediaType.parseMediaType((String)file.getContentType()));
        }
        return new OperationRequestPartFactory().create(file.getName(), StringUtils.hasText((String)file.getOriginalFilename()) ? file.getOriginalFilename() : null, file.getBytes(), partHeaders);
    }

    private HttpHeaders extractHeaders(Part part) {
        HttpHeaders partHeaders = new HttpHeaders();
        for (String headerName : part.getHeaderNames()) {
            for (String value : part.getHeaders(headerName)) {
                partHeaders.add(headerName, value);
            }
        }
        return partHeaders;
    }

    private Parameters extractParameters(MockHttpServletRequest servletRequest) {
        Parameters parameters = new Parameters();
        for (String name : IterableEnumeration.iterable(servletRequest.getParameterNames())) {
            for (String value : servletRequest.getParameterValues(name)) {
                parameters.add((Object)name, (Object)value);
            }
        }
        return parameters;
    }

    private HttpHeaders extractHeaders(MockHttpServletRequest servletRequest) {
        HttpHeaders headers = new HttpHeaders();
        for (String headerName : IterableEnumeration.iterable(servletRequest.getHeaderNames())) {
            for (String value : IterableEnumeration.iterable(servletRequest.getHeaders(headerName))) {
                headers.add(headerName, value);
            }
        }
        return headers;
    }

    private boolean isNonStandardPort(MockHttpServletRequest request) {
        return SCHEME_HTTP.equals(request.getScheme()) && request.getServerPort() != 80 || SCHEME_HTTPS.equals(request.getScheme()) && request.getServerPort() != 443;
    }

    private String getRequestUri(MockHttpServletRequest request) {
        StringWriter uriWriter = new StringWriter();
        PrintWriter printer = new PrintWriter(uriWriter);
        printer.printf("%s://%s", request.getScheme(), request.getServerName());
        if (this.isNonStandardPort(request)) {
            printer.printf(":%d", request.getServerPort());
        }
        printer.print(request.getRequestURI());
        return uriWriter.toString();
    }
}

