/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.listener.adapter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.HandlerMethod;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.support.PayloadMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.pulsar.PulsarException;
import org.springframework.pulsar.listener.adapter.InvocationResult;
import org.springframework.validation.Validator;

public class DelegatingInvocableHandler {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private final List<InvocableHandlerMethod> handlers;
    private final ConcurrentMap<Class<?>, InvocableHandlerMethod> cachedHandlers = new ConcurrentHashMap();
    private final ConcurrentMap<InvocableHandlerMethod, MethodParameter> payloadMethodParameters = new ConcurrentHashMap<InvocableHandlerMethod, MethodParameter>();
    private final @Nullable InvocableHandlerMethod defaultHandler;
    private final Map<InvocableHandlerMethod, Expression> handlerSendTo = new ConcurrentHashMap<InvocableHandlerMethod, Expression>();
    private final Map<InvocableHandlerMethod, Boolean> handlerReturnsMessage = new ConcurrentHashMap<InvocableHandlerMethod, Boolean>();
    private final Object bean;
    private final @Nullable BeanExpressionResolver resolver;
    private final @Nullable BeanExpressionContext beanExpressionContext;
    private final @Nullable ConfigurableListableBeanFactory beanFactory;
    private final @Nullable PayloadValidator validator;

    public DelegatingInvocableHandler(List<InvocableHandlerMethod> handlers, @Nullable InvocableHandlerMethod defaultHandler, Object bean, @Nullable BeanExpressionResolver beanExpressionResolver, @Nullable BeanExpressionContext beanExpressionContext, @Nullable BeanFactory beanFactory, @Nullable Validator validator) {
        this.handlers = new ArrayList<InvocableHandlerMethod>();
        for (InvocableHandlerMethod handler : handlers) {
            this.handlers.add(this.wrapIfNecessary(handler));
        }
        this.defaultHandler = this.wrapIfNecessary(defaultHandler);
        this.bean = bean;
        this.resolver = beanExpressionResolver;
        this.beanExpressionContext = beanExpressionContext;
        this.beanFactory = beanFactory instanceof ConfigurableListableBeanFactory ? (ConfigurableListableBeanFactory)beanFactory : null;
        this.validator = validator == null ? null : new PayloadValidator(validator);
    }

    private @Nullable InvocableHandlerMethod wrapIfNecessary(@Nullable InvocableHandlerMethod handler) {
        Parameter[] parameters;
        if (handler == null) {
            return null;
        }
        for (Parameter parameter : parameters = handler.getMethod().getParameters()) {
        }
        return handler;
    }

    public Object getBean() {
        return this.bean;
    }

    public Object invoke(Message<?> message, Object ... providedArgs) throws Exception {
        MethodParameter parameter;
        Class<?> payloadClass = message.getPayload().getClass();
        InvocableHandlerMethod handler = this.getHandlerForPayload(payloadClass);
        if (this.validator != null && this.defaultHandler != null && (parameter = (MethodParameter)this.payloadMethodParameters.get(handler)) != null) {
            this.validator.validate(message, parameter, message.getPayload());
        }
        Object result = null;
        if (!(handler instanceof MetadataAwareInvocableHandlerMethod)) {
            result = handler.invoke(message, providedArgs);
        }
        Expression replyTo = this.handlerSendTo.get(handler);
        return new InvocationResult(result, replyTo, this.handlerReturnsMessage.get(handler));
    }

    protected InvocableHandlerMethod getHandlerForPayload(Class<? extends Object> payloadClass) {
        InvocableHandlerMethod handler = (InvocableHandlerMethod)this.cachedHandlers.get(payloadClass);
        if (handler == null) {
            handler = this.findHandlerForPayload(payloadClass);
            if (handler == null) {
                throw new PulsarException("No method found for " + String.valueOf(payloadClass));
            }
            this.cachedHandlers.putIfAbsent(payloadClass, handler);
        }
        return handler;
    }

    protected @Nullable InvocableHandlerMethod findHandlerForPayload(Class<? extends Object> payloadClass) {
        InvocableHandlerMethod result = null;
        for (InvocableHandlerMethod handler : this.handlers) {
            if (!this.matchHandlerMethod(payloadClass, handler)) continue;
            if (result != null) {
                boolean resultIsDefault = result.equals((Object)this.defaultHandler);
                if (!handler.equals((Object)this.defaultHandler) && !resultIsDefault) {
                    throw new PulsarException("Ambiguous methods for payload type: " + String.valueOf(payloadClass) + ": " + result.getMethod().getName() + " and " + handler.getMethod().getName());
                }
                if (!resultIsDefault) continue;
            }
            result = handler;
        }
        return result != null ? result : this.defaultHandler;
    }

    protected boolean matchHandlerMethod(Class<? extends Object> payloadClass, InvocableHandlerMethod handler) {
        MethodParameter methodParameter;
        Method method = handler.getMethod();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length == 1 && ((methodParameter = new MethodParameter(method, 0)).getParameterAnnotations().length == 0 || !methodParameter.hasParameterAnnotation(Header.class)) && methodParameter.getParameterType().isAssignableFrom(payloadClass)) {
            if (this.validator != null) {
                this.payloadMethodParameters.put(handler, methodParameter);
            }
            return true;
        }
        MethodParameter foundCandidate = this.findCandidate(payloadClass, method, parameterAnnotations);
        if (foundCandidate != null && this.validator != null) {
            this.payloadMethodParameters.put(handler, foundCandidate);
        }
        return foundCandidate != null;
    }

    private @Nullable MethodParameter findCandidate(Class<? extends Object> payloadClass, Method method, Annotation[][] parameterAnnotations) {
        MethodParameter foundCandidate = null;
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            MethodParameter methodParameter = new MethodParameter(method, i);
            if (methodParameter.getParameterAnnotations().length != 0 && methodParameter.hasParameterAnnotation(Header.class) || !methodParameter.getParameterType().isAssignableFrom(payloadClass)) continue;
            if (foundCandidate != null) {
                throw new PulsarException("Ambiguous payload parameter for " + method.toGenericString());
            }
            foundCandidate = methodParameter;
        }
        return foundCandidate;
    }

    public String getMethodNameFor(Object payload) {
        InvocableHandlerMethod handlerForPayload = this.getHandlerForPayload(payload.getClass());
        return handlerForPayload == null ? "no match" : handlerForPayload.getMethod().toGenericString();
    }

    public boolean hasDefaultHandler() {
        return this.defaultHandler != null;
    }

    private static final class PayloadValidator
    extends PayloadMethodArgumentResolver {
        PayloadValidator(Validator validator) {
            super(new MessageConverter(){

                public @Nullable Message<?> toMessage(Object payload, @Nullable MessageHeaders headers) {
                    return null;
                }

                public @Nullable Object fromMessage(Message<?> message, Class<?> targetClass) {
                    return null;
                }
            }, validator);
        }

        public void validate(Message<?> message, MethodParameter parameter, Object target) {
            super.validate(message, parameter, target);
        }
    }

    private static final class MetadataAwareInvocableHandlerMethod
    extends InvocableHandlerMethod {
        MetadataAwareInvocableHandlerMethod(HandlerMethod handlerMethod) {
            super(handlerMethod);
        }
    }
}

