/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.listener;

import java.util.concurrent.locks.ReentrantLock;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.jspecify.annotations.Nullable;
import org.springframework.pulsar.core.AbstractPulsarMessageContainer;
import org.springframework.pulsar.core.ConsumerBuilderCustomizer;
import org.springframework.pulsar.core.PulsarConsumerFactory;
import org.springframework.pulsar.listener.PulsarConsumerErrorHandler;
import org.springframework.pulsar.listener.PulsarContainerProperties;
import org.springframework.pulsar.listener.PulsarMessageListenerContainer;
import org.springframework.pulsar.listener.PulsarRecordMessageListener;
import org.springframework.util.Assert;

public abstract class AbstractPulsarMessageListenerContainer<T>
extends AbstractPulsarMessageContainer
implements PulsarMessageListenerContainer {
    private final PulsarConsumerFactory<T> pulsarConsumerFactory;
    private final PulsarContainerProperties pulsarContainerProperties;
    protected final ReentrantLock lifecycleLock = new ReentrantLock();
    private volatile boolean paused;
    protected @Nullable RedeliveryBackoff negativeAckRedeliveryBackoff;
    protected @Nullable RedeliveryBackoff ackTimeoutRedeliveryBackoff;
    protected @Nullable DeadLetterPolicy deadLetterPolicy;
    protected @Nullable PulsarConsumerErrorHandler<T> pulsarConsumerErrorHandler;
    protected @Nullable ConsumerBuilderCustomizer<T> consumerBuilderCustomizer;

    protected AbstractPulsarMessageListenerContainer(PulsarConsumerFactory<? super T> pulsarConsumerFactory, PulsarContainerProperties pulsarContainerProperties) {
        this.pulsarConsumerFactory = pulsarConsumerFactory;
        this.pulsarContainerProperties = pulsarContainerProperties;
    }

    public PulsarConsumerFactory<T> getPulsarConsumerFactory() {
        return this.pulsarConsumerFactory;
    }

    @Override
    public PulsarContainerProperties getContainerProperties() {
        return this.pulsarContainerProperties;
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void setRunning(boolean running) {
        this.running = running;
    }

    @Override
    public void setupMessageListener(Object messageListener) {
        this.pulsarContainerProperties.setMessageListener(messageListener);
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    @Override
    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public final void start() {
        this.lifecycleLock.lock();
        try {
            if (!this.isRunning()) {
                Assert.state((boolean)(this.pulsarContainerProperties.getMessageListener() instanceof PulsarRecordMessageListener), () -> "A " + PulsarRecordMessageListener.class.getName() + " implementation must be provided");
                this.doStart();
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public void stop() {
        this.lifecycleLock.lock();
        try {
            if (this.isRunning()) {
                this.doStop();
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Override
    public void setNegativeAckRedeliveryBackoff(@Nullable RedeliveryBackoff redeliveryBackoff) {
        this.negativeAckRedeliveryBackoff = redeliveryBackoff;
    }

    @Override
    public void setAckTimeoutRedeliveryBackoff(@Nullable RedeliveryBackoff redeliveryBackoff) {
        this.ackTimeoutRedeliveryBackoff = redeliveryBackoff;
    }

    public @Nullable RedeliveryBackoff getNegativeAckRedeliveryBackoff() {
        return this.negativeAckRedeliveryBackoff;
    }

    public @Nullable RedeliveryBackoff getAckTimeoutkRedeliveryBackoff() {
        return this.ackTimeoutRedeliveryBackoff;
    }

    @Override
    public void setDeadLetterPolicy(@Nullable DeadLetterPolicy deadLetterPolicy) {
        this.deadLetterPolicy = deadLetterPolicy;
    }

    public @Nullable DeadLetterPolicy getDeadLetterPolicy() {
        return this.deadLetterPolicy;
    }

    public @Nullable PulsarConsumerErrorHandler<T> getPulsarConsumerErrorHandler() {
        return this.pulsarConsumerErrorHandler;
    }

    @Override
    public void setPulsarConsumerErrorHandler(@Nullable PulsarConsumerErrorHandler pulsarConsumerErrorHandler) {
        this.pulsarConsumerErrorHandler = pulsarConsumerErrorHandler;
    }

    @Override
    public void setConsumerCustomizer(@Nullable ConsumerBuilderCustomizer<?> consumerBuilderCustomizer) {
        this.consumerBuilderCustomizer = consumerBuilderCustomizer;
    }

    public @Nullable ConsumerBuilderCustomizer<T> getConsumerBuilderCustomizer() {
        return this.consumerBuilderCustomizer;
    }

    @Override
    public void pause() {
        this.lifecycleLock.lock();
        try {
            this.doPause();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Override
    public void resume() {
        this.lifecycleLock.lock();
        try {
            this.doResume();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    protected boolean isPaused() {
        return this.paused;
    }

    protected void setPaused(boolean paused) {
        this.paused = paused;
    }

    protected abstract void doPause();

    protected abstract void doResume();
}

