/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.function;

import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.common.io.SinkConfig;
import org.jspecify.annotations.Nullable;
import org.springframework.pulsar.PulsarException;
import org.springframework.pulsar.function.PulsarFunctionOperations;

public record PulsarSink(SinkConfig config, PulsarFunctionOperations.FunctionStopPolicy stopPolicy, @Nullable UpdateOptions updateOptions) implements PulsarFunctionOperations<SinkConfig>
{
    public PulsarSink(SinkConfig config, @Nullable UpdateOptions updateOptions) {
        this(config, PulsarFunctionOperations.FunctionStopPolicy.DELETE, updateOptions);
    }

    @Override
    public String name() {
        return this.config().getName();
    }

    @Override
    public PulsarFunctionOperations.FunctionType type() {
        return PulsarFunctionOperations.FunctionType.SINK;
    }

    @Override
    public String archive() {
        return this.config().getArchive();
    }

    @Override
    public SinkConfig get(PulsarAdmin admin) throws PulsarAdminException {
        return admin.sinks().getSink(this.config().getTenant(), this.config().getNamespace(), this.config().getName());
    }

    @Override
    public void updateWithUrl(PulsarAdmin admin) throws PulsarAdminException {
        admin.sinks().updateSinkWithUrl(this.config(), this.archive(), this.updateOptions());
    }

    @Override
    public void update(PulsarAdmin admin) throws PulsarAdminException {
        admin.sinks().updateSink(this.config(), this.archive(), this.updateOptions());
    }

    @Override
    public void createWithUrl(PulsarAdmin admin) throws PulsarAdminException {
        admin.sinks().createSinkWithUrl(this.config(), this.archive());
    }

    @Override
    public void create(PulsarAdmin admin) throws PulsarAdminException {
        admin.sinks().createSink(this.config(), this.archive());
    }

    @Override
    public void stop(PulsarAdmin admin) {
        try {
            admin.sinks().stopSink(this.config().getTenant(), this.config().getNamespace(), this.config().getName());
        }
        catch (PulsarAdminException e) {
            throw new PulsarException(e.getMessage(), e);
        }
    }

    @Override
    public void delete(PulsarAdmin admin) {
        try {
            admin.sinks().deleteSink(this.config().getTenant(), this.config().getNamespace(), this.config().getName());
        }
        catch (PulsarAdminException e) {
            throw new PulsarException(e.getMessage(), e);
        }
    }
}

