/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.log.LogAccessor;
import org.springframework.pulsar.core.RestartableComponentBase;
import org.springframework.util.Assert;

abstract class RestartableSingletonFactory<T>
extends RestartableComponentBase
implements InitializingBean {
    private final LogAccessor logger = new LogAccessor(this.getClass());
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private @Nullable T instance;

    protected RestartableSingletonFactory() {
    }

    protected RestartableSingletonFactory(T instance) {
        Assert.notNull(instance, () -> "instance must not be null");
        this.instance = instance;
        this.initialized.set(true);
    }

    public void afterPropertiesSet() throws Exception {
        this.ensureInstanceCreated();
    }

    @Override
    public void doStart() {
        this.ensureInstanceCreated();
    }

    private void ensureInstanceCreated() {
        if (this.initialized.compareAndSet(false, true)) {
            this.logger.debug(() -> "Creating instance");
            this.instance = this.createInstance();
        }
    }

    @Override
    public void doStop() {
        if (this.instance != null) {
            this.logger.debug(() -> "Stopping instance");
            this.stopInstance(this.instance);
            if (this.discardInstanceAfterStop()) {
                this.logger.debug(() -> "Discarding instance");
                this.instance = null;
            }
        }
        this.initialized.set(false);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.instance = null;
    }

    public final @Nullable T getInstance() {
        return this.instance;
    }

    public final T getRequiredInstance() {
        Assert.notNull(this.instance, (String)"The instance must be set prior to calling this method");
        return this.instance;
    }

    protected abstract T createInstance();

    protected void stopInstance(T instance) {
    }

    protected boolean discardInstanceAfterStop() {
        return true;
    }

    protected boolean initialized() {
        return this.initialized.get();
    }
}

