/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Schema;
import org.jspecify.annotations.Nullable;
import org.springframework.pulsar.PulsarException;
import org.springframework.pulsar.core.ProducerBuilderCustomizer;
import org.springframework.pulsar.core.TypedMessageBuilderCustomizer;

public interface PulsarOperations<T> {
    public MessageId send(@Nullable T var1);

    public MessageId send(@Nullable T var1, @Nullable Schema<T> var2);

    public MessageId send(@Nullable String var1, @Nullable T var2);

    public MessageId send(@Nullable String var1, @Nullable T var2, @Nullable Schema<T> var3);

    public CompletableFuture<MessageId> sendAsync(@Nullable T var1);

    public CompletableFuture<MessageId> sendAsync(@Nullable T var1, @Nullable Schema<T> var2);

    public CompletableFuture<MessageId> sendAsync(@Nullable String var1, @Nullable T var2);

    public CompletableFuture<MessageId> sendAsync(@Nullable String var1, @Nullable T var2, @Nullable Schema<T> var3) throws PulsarException;

    public SendMessageBuilder<T> newMessage(@Nullable T var1);

    public static interface SendMessageBuilder<T> {
        public SendMessageBuilder<T> withTopic(String var1);

        public SendMessageBuilder<T> withSchema(Schema<T> var1);

        public SendMessageBuilder<T> withEncryptionKeys(Collection<String> var1);

        public SendMessageBuilder<T> withMessageCustomizer(TypedMessageBuilderCustomizer<T> var1);

        public SendMessageBuilder<T> withProducerCustomizer(ProducerBuilderCustomizer<T> var1);

        public MessageId send();

        public CompletableFuture<MessageId> sendAsync();
    }
}

