/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Messages;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.log.LogAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.pulsar.config.AbstractPulsarReaderEndpoint;
import org.springframework.pulsar.core.ReaderBuilderCustomizer;
import org.springframework.pulsar.core.SchemaResolver;
import org.springframework.pulsar.listener.Acknowledgement;
import org.springframework.pulsar.listener.adapter.AbstractPulsarMessageToSpringMessageAdapter;
import org.springframework.pulsar.listener.adapter.HandlerAdapter;
import org.springframework.pulsar.listener.adapter.PulsarRecordMessageToSpringMessageReaderAdapter;
import org.springframework.pulsar.reader.DefaultPulsarMessageReaderContainer;
import org.springframework.pulsar.reader.PulsarMessageReaderContainer;
import org.springframework.pulsar.reader.PulsarReaderContainerProperties;
import org.springframework.pulsar.support.MessageConverter;
import org.springframework.pulsar.support.converter.PulsarMessageConverter;
import org.springframework.util.Assert;

public class MethodPulsarReaderEndpoint<V>
extends AbstractPulsarReaderEndpoint<V> {
    private final LogAccessor logger = new LogAccessor(this.getClass());
    private @Nullable Object bean;
    private @Nullable Method method;
    private @Nullable ObjectMapper objectMapper;
    private @Nullable SmartMessageConverter messagingConverter;
    private @Nullable MessageHandlerMethodFactory messageHandlerMethodFactory;
    private @Nullable ReaderBuilderCustomizer<?> readerBuilderCustomizer;

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public @Nullable Object getBean() {
        return this.bean;
    }

    protected Object requireNonNullBean() {
        Assert.notNull((Object)this.bean, (String)"Bean must not be null");
        return this.bean;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public @Nullable Method getMethod() {
        return this.method;
    }

    protected Method requireNonNullMethod() {
        Assert.notNull((Object)this.method, (String)"Method must not be null");
        return this.method;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    protected AbstractPulsarMessageToSpringMessageAdapter<V> createReaderListener(PulsarMessageReaderContainer container, @Nullable MessageConverter messageConverter) {
        SchemaInfo schemaInfo;
        MessageHandlerMethodFactory messageHandlerMethodFactory = this.requireNonNullMessageHandlerMethodFactory();
        AbstractPulsarMessageToSpringMessageAdapter<V> readerListener = this.createMessageListenerInstance(messageConverter);
        HandlerAdapter handlerMethod = this.configureListenerAdapter(readerListener, messageHandlerMethodFactory);
        readerListener.setHandlerMethod(handlerMethod);
        MethodParameter[] methodParameters = handlerMethod.requireNonNullInvokerHandlerMethod().getMethodParameters();
        List<MethodParameter> allPayloadParams = Arrays.stream(methodParameters).filter(param -> !param.getParameterType().equals(Consumer.class) && !param.getParameterType().equals(Acknowledgement.class) && !param.hasParameterAnnotation(Header.class)).toList();
        Assert.isTrue((allPayloadParams.size() == 1 ? 1 : 0) != 0, (String)("Expected 1 payload types but found " + String.valueOf(allPayloadParams)));
        MethodParameter messageParameter = (MethodParameter)allPayloadParams.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to determine message parameter"));
        DefaultPulsarMessageReaderContainer containerInstance = (DefaultPulsarMessageReaderContainer)container;
        PulsarReaderContainerProperties pulsarContainerProperties = containerInstance.getContainerProperties();
        SchemaResolver schemaResolver = pulsarContainerProperties.getSchemaResolver();
        SchemaType schemaType = Objects.requireNonNull(pulsarContainerProperties.getSchemaType(), "pulsarContainerProperties.getSchemaType() must not be null");
        ResolvableType messageType = this.resolvableType(messageParameter);
        schemaResolver.resolveSchema(schemaType, messageType).ifResolvedOrElse(pulsarContainerProperties::setSchema, ex -> this.logger.warn(() -> "Failed to resolve schema for type %s - will default to BYTES (due to: %s)".formatted(schemaType, ex.getMessage())));
        if (pulsarContainerProperties.getSchema() != null && (schemaInfo = pulsarContainerProperties.getSchema().getSchemaInfo()) != null) {
            pulsarContainerProperties.setSchemaType(schemaInfo.getType());
        }
        if (this.readerBuilderCustomizer != null) {
            container.setReaderCustomizer(this.readerBuilderCustomizer);
        }
        return readerListener;
    }

    private ResolvableType resolvableType(MethodParameter methodParameter) {
        ResolvableType resolvableType = ResolvableType.forMethodParameter((MethodParameter)methodParameter);
        Class rawClass = resolvableType.getRawClass();
        if (rawClass != null && this.isContainerType(rawClass)) {
            resolvableType = resolvableType.getGeneric(new int[]{0});
        }
        if (resolvableType.getRawClass() != null && (Message.class.isAssignableFrom(resolvableType.getRawClass()) || org.springframework.messaging.Message.class.isAssignableFrom(resolvableType.getRawClass()))) {
            resolvableType = resolvableType.getGeneric(new int[]{0});
        }
        return resolvableType;
    }

    private boolean isContainerType(Class<?> rawClass) {
        return rawClass.isAssignableFrom(List.class) || rawClass.isAssignableFrom(Message.class) || rawClass.isAssignableFrom(Messages.class) || rawClass.isAssignableFrom(org.springframework.messaging.Message.class);
    }

    protected HandlerAdapter configureListenerAdapter(AbstractPulsarMessageToSpringMessageAdapter<V> messageListener, MessageHandlerMethodFactory messageHandlerMethodFactory) {
        InvocableHandlerMethod invocableHandlerMethod = messageHandlerMethodFactory.createInvocableHandlerMethod(this.requireNonNullBean(), this.requireNonNullMethod());
        return new HandlerAdapter(invocableHandlerMethod);
    }

    protected AbstractPulsarMessageToSpringMessageAdapter<V> createMessageListenerInstance(@Nullable MessageConverter messageConverter) {
        BeanResolver resolver;
        PulsarRecordMessageToSpringMessageReaderAdapter listener = new PulsarRecordMessageToSpringMessageReaderAdapter(this.requireNonNullBean(), this.requireNonNullMethod());
        if (messageConverter instanceof PulsarMessageConverter) {
            PulsarMessageConverter pulsarMessageConverter = (PulsarMessageConverter)messageConverter;
            listener.setMessageConverter(pulsarMessageConverter);
        }
        if (this.messagingConverter != null) {
            listener.setMessagingConverter(this.messagingConverter);
        }
        if (this.objectMapper != null) {
            listener.setObjectMapper(this.objectMapper);
        }
        if ((resolver = this.getBeanResolver()) != null) {
            listener.setBeanResolver(resolver);
        }
        return listener;
    }

    public void setMessagingConverter(SmartMessageConverter messagingConverter) {
        this.messagingConverter = messagingConverter;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }

    protected MessageHandlerMethodFactory requireNonNullMessageHandlerMethodFactory() {
        Assert.notNull((Object)this.messageHandlerMethodFactory, (String)"The messageHandlerMethodFactory must not be null");
        return this.messageHandlerMethodFactory;
    }

    public @Nullable ReaderBuilderCustomizer<?> getReaderBuilderCustomizer() {
        return this.readerBuilderCustomizer;
    }

    public void setReaderBuilderCustomizer(ReaderBuilderCustomizer<?> readerBuilderCustomizer) {
        this.readerBuilderCustomizer = readerBuilderCustomizer;
    }
}

