/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.annotation;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.Assert;

public final class PulsarHeaderObjectMapperUtils {
    private static final String PULSAR_HEADER_OBJECT_MAPPER_BEAN_NAME = "pulsarHeaderObjectMapper";
    private static final LogAccessor LOG = new LogAccessor(PulsarHeaderObjectMapperUtils.class);

    private PulsarHeaderObjectMapperUtils() {
    }

    public static Optional<ObjectMapper> customMapper(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"beanFactory must not be null");
        try {
            return Optional.of((ObjectMapper)beanFactory.getBean(PULSAR_HEADER_OBJECT_MAPPER_BEAN_NAME, ObjectMapper.class));
        }
        catch (NoSuchBeanDefinitionException ex) {
            LOG.debug(() -> "No '%s' bean defined - will use standard object mapper for header values".formatted(PULSAR_HEADER_OBJECT_MAPPER_BEAN_NAME));
            return Optional.empty();
        }
    }
}

