/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.reader;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.SchemaType;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.config.StartupFailurePolicy;
import org.springframework.pulsar.core.DefaultSchemaResolver;
import org.springframework.pulsar.core.SchemaResolver;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class PulsarReaderContainerProperties {
    private static final Duration DEFAULT_READER_START_TIMEOUT = Duration.ofSeconds(30L);
    private Duration readerStartTimeout = DEFAULT_READER_START_TIMEOUT;
    private Object readerListener;
    private AsyncTaskExecutor readerTaskExecutor;
    private List<String> topics;
    private MessageId startMessageId;
    private Schema<?> schema;
    private SchemaType schemaType;
    private SchemaResolver schemaResolver;
    @Nullable
    private RetryTemplate startupFailureRetryTemplate;
    private final RetryTemplate defaultStartupFailureRetryTemplate = RetryTemplate.builder().maxAttempts(3).fixedBackoff(Duration.ofSeconds(10L)).build();
    private StartupFailurePolicy startupFailurePolicy = StartupFailurePolicy.STOP;

    public Object getReaderListener() {
        return this.readerListener;
    }

    public PulsarReaderContainerProperties() {
        this.schemaResolver = new DefaultSchemaResolver();
    }

    public void setReaderListener(Object readerListener) {
        this.readerListener = readerListener;
    }

    public AsyncTaskExecutor getReaderTaskExecutor() {
        return this.readerTaskExecutor;
    }

    public void setReaderTaskExecutor(AsyncTaskExecutor readerExecutor) {
        this.readerTaskExecutor = readerExecutor;
    }

    public Duration getReaderStartTimeout() {
        return this.readerStartTimeout;
    }

    public void setReaderStartTimeout(Duration readerStartTimeout) {
        Assert.notNull((Object)readerStartTimeout, (String)"'readerStartTimeout' cannot be null");
        this.readerStartTimeout = readerStartTimeout;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public void setTopics(List<String> topics) {
        this.topics = topics;
    }

    public MessageId getStartMessageId() {
        return this.startMessageId;
    }

    public void setStartMessageId(MessageId startMessageId) {
        this.startMessageId = startMessageId;
    }

    public Schema<?> getSchema() {
        return this.schema;
    }

    public void setSchema(Schema<?> schema) {
        this.schema = schema;
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
    }

    public SchemaResolver getSchemaResolver() {
        return this.schemaResolver;
    }

    public void setSchemaResolver(SchemaResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
    }

    @Nullable
    public RetryTemplate getStartupFailureRetryTemplate() {
        return this.startupFailureRetryTemplate;
    }

    public RetryTemplate getDefaultStartupFailureRetryTemplate() {
        return this.defaultStartupFailureRetryTemplate;
    }

    public void setStartupFailureRetryTemplate(RetryTemplate startupFailureRetryTemplate) {
        this.startupFailureRetryTemplate = startupFailureRetryTemplate;
        if (this.startupFailureRetryTemplate != null) {
            this.setStartupFailurePolicy(StartupFailurePolicy.RETRY);
        }
    }

    public StartupFailurePolicy getStartupFailurePolicy() {
        return this.startupFailurePolicy;
    }

    public void setStartupFailurePolicy(StartupFailurePolicy startupFailurePolicy) {
        this.startupFailurePolicy = Objects.requireNonNull(startupFailurePolicy, "startupFailurePolicy must not be null");
    }
}

