/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import org.apache.pulsar.common.naming.TopicDomain;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.core.PulsarTopic;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PulsarTopicBuilder {
    private static final String FQ_TOPIC_NAME_FORMAT = "%s://%s/%s/%s";
    private static final String DEFAULT_TENANT = "public";
    private static final String DEFAULT_NAMESPACE = "default";
    private final TopicDomain defaultDomain;
    private final String defaultTenant;
    private final String defaultNamespace;
    @Nullable
    private String name;
    @Nullable
    private int numberOfPartitions;

    public PulsarTopicBuilder() {
        this(TopicDomain.persistent, DEFAULT_TENANT, DEFAULT_NAMESPACE);
    }

    public PulsarTopicBuilder(TopicDomain defaultDomain, @Nullable String defaultTenant, @Nullable String defaultNamespace) {
        Assert.notNull((Object)defaultDomain, (String)"defaultDomain must not be null");
        this.defaultDomain = defaultDomain;
        this.defaultTenant = StringUtils.hasText((String)defaultTenant) ? defaultTenant : DEFAULT_TENANT;
        this.defaultNamespace = StringUtils.hasText((String)defaultNamespace) ? defaultNamespace : DEFAULT_NAMESPACE;
    }

    public String getFullyQualifiedNameForTopic(String topicName) {
        return this.fullyQualifiedName(topicName);
    }

    public PulsarTopicBuilder name(String name) {
        this.name = this.fullyQualifiedName(name);
        return this;
    }

    private String fullyQualifiedName(String name) {
        Assert.notNull((Object)name, (String)"name must not be null");
        String[] splitTopic = name.split("/");
        if (splitTopic.length == 1) {
            return FQ_TOPIC_NAME_FORMAT.formatted(this.defaultDomain, this.defaultTenant, this.defaultNamespace, splitTopic[0]);
        }
        if (splitTopic.length == 3) {
            return FQ_TOPIC_NAME_FORMAT.formatted(this.defaultDomain, splitTopic[0], splitTopic[1], splitTopic[2]);
        }
        if (splitTopic.length == 5) {
            String type = splitTopic[0].replace(":", "");
            return FQ_TOPIC_NAME_FORMAT.formatted(TopicDomain.getEnum((String)type), splitTopic[2], splitTopic[3], splitTopic[4]);
        }
        throw new IllegalArgumentException("Topic name '" + name + "' must be in one of the following formats ('name', 'tenant/namespace/name', 'domain://tenant/namespace/name')");
    }

    public PulsarTopicBuilder numberOfPartitions(int numberOfPartitions) {
        this.numberOfPartitions = numberOfPartitions;
        return this;
    }

    public PulsarTopic build() {
        return new PulsarTopic(this.name, this.numberOfPartitions);
    }
}

