/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.regex.Pattern;
import org.apache.pulsar.common.naming.TopicDomain;
import org.springframework.pulsar.core.PulsarTopicBuilder;
import org.springframework.util.Assert;

public record PulsarTopic(String topicName, int numberOfPartitions) {
    private static final String NAME_PATTERN_STR = "[-=:\\.\\w]*";
    private static Pattern TOPIC_NAME_PATTERN = Pattern.compile("(persistent|non-persistent)\\:\\/\\/(%s)\\/(%s)\\/(%s)".formatted("[-=:\\.\\w]*", "[-=:\\.\\w]*", "[-=:\\.\\w]*"));
    private static final String INVALID_NAME_MSG = "topicName %s must be fully-qualified in the format 'domain://tenant/namespace/name' where domain is one of ('persistent', 'non-persistent') and the other components must be composed of one or more letters, digits, or special characters ('-', '=', ':', or '.')";

    public PulsarTopic {
        Assert.state((boolean)TOPIC_NAME_PATTERN.matcher(topicName).matches(), (String)INVALID_NAME_MSG.formatted(topicName));
        Assert.state((numberOfPartitions >= 0 ? 1 : 0) != 0, (String)"numberOfPartitions must be >= 0");
    }

    @Deprecated(since="1.2.0", forRemoval=true)
    public static PulsarTopicBuilder builder(String topicName) {
        return new PulsarTopicBuilder().name(topicName);
    }

    public boolean isPartitioned() {
        return this.numberOfPartitions != 0;
    }

    public TopicComponents getComponents() {
        String[] splitTopic = this.topicName().split("/");
        String type = splitTopic[0].replace(":", "");
        return new TopicComponents(TopicDomain.getEnum((String)type), splitTopic[2], splitTopic[3], splitTopic[4]);
    }

    @Deprecated(since="1.2.0", forRemoval=true)
    public String getFullyQualifiedTopicName() {
        return this.topicName();
    }

    record TopicComponents(TopicDomain domain, String tenant, String namespace, String name) {
    }
}

