/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.annotation.PulsarMessage;
import org.springframework.pulsar.core.DefaultExpressionResolver;
import org.springframework.pulsar.core.ExpressionResolver;
import org.springframework.pulsar.core.PulsarMessageAnnotationRegistry;
import org.springframework.pulsar.core.Resolved;
import org.springframework.pulsar.core.TopicResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DefaultTopicResolver
implements TopicResolver,
BeanFactoryAware,
BeanClassLoaderAware {
    private final LogAccessor logger = new LogAccessor(this.getClass());
    private final Map<String, String> customTopicMappings = new LinkedHashMap<String, String>();
    private final PulsarMessageAnnotationRegistry pulsarMessageAnnotationRegistry = new PulsarMessageAnnotationRegistry();
    private boolean usePulsarMessageAnnotations = true;
    @Nullable
    private ExpressionResolver expressionResolver;
    @Nullable
    private ClassLoader classLoader;

    public DefaultTopicResolver(ExpressionResolver expressionResolver) {
        this.expressionResolver = expressionResolver;
    }

    public DefaultTopicResolver() {
    }

    public void usePulsarMessageAnnotations(boolean usePulsarMessageAnnotations) {
        this.usePulsarMessageAnnotations = usePulsarMessageAnnotations;
    }

    @Nullable
    public String addCustomTopicMapping(Class<?> messageType, String topic) {
        return this.customTopicMappings.put(this.toMessageTypeMapKey(messageType), topic);
    }

    @Nullable
    public String removeCustomMapping(Class<?> messageType) {
        return this.customTopicMappings.remove(this.toMessageTypeMapKey(messageType));
    }

    @Deprecated(since="1.2.5", forRemoval=true)
    public Map<Class<?>, String> getCustomTopicMappings() {
        return this.customTopicMappings.entrySet().stream().collect(Collectors.toMap(e -> this.fromMessageTypeMapKey((String)e.getKey()), Map.Entry::getValue));
    }

    public Optional<String> getCustomTopicMapping(Class<?> messageType) {
        return Optional.ofNullable(this.customTopicMappings.get(this.toMessageTypeMapKey(messageType)));
    }

    @Override
    public Resolved<String> resolveTopic(@Nullable String userSpecifiedTopic, Supplier<String> defaultTopicSupplier) {
        if (StringUtils.hasText((String)userSpecifiedTopic)) {
            return Resolved.of(userSpecifiedTopic);
        }
        String defaultTopic = defaultTopicSupplier.get();
        if (defaultTopic == null) {
            return Resolved.failed("Topic must be specified when no default topic is configured");
        }
        return Resolved.of(defaultTopic);
    }

    @Override
    public <T> Resolved<String> resolveTopic(@Nullable String userSpecifiedTopic, @Nullable T message, Supplier<String> defaultTopicSupplier) {
        return this.doResolveTopic(userSpecifiedTopic, message != null ? message.getClass() : null, defaultTopicSupplier);
    }

    @Override
    public Resolved<String> resolveTopic(@Nullable String userSpecifiedTopic, @Nullable Class<?> messageType, Supplier<String> defaultTopicSupplier) {
        return this.doResolveTopic(userSpecifiedTopic, messageType, defaultTopicSupplier);
    }

    protected Resolved<String> doResolveTopic(@Nullable String userSpecifiedTopic, @Nullable Class<?> messageType, Supplier<String> defaultTopicSupplier) {
        if (StringUtils.hasText((String)userSpecifiedTopic)) {
            return Resolved.of(userSpecifiedTopic);
        }
        if (messageType == null) {
            return Resolved.failed("Topic must be specified when the message is null");
        }
        String topic = this.customTopicMappings.get(this.toMessageTypeMapKey(messageType));
        if (this.usePulsarMessageAnnotations && topic == null && (topic = this.getAnnotatedTopicInfo(messageType)) != null) {
            this.addCustomTopicMapping(messageType, topic);
        }
        if (topic == null) {
            topic = defaultTopicSupplier.get();
        }
        return topic == null ? Resolved.failed("Topic must be specified when no default topic is configured") : Resolved.of(topic);
    }

    @Nullable
    String getAnnotatedTopicInfo(Class<?> messageType) {
        return this.pulsarMessageAnnotationRegistry.getAnnotationFor(messageType).map(PulsarMessage::topic).filter(StringUtils::hasText).map(this::resolveExpression).orElse(null);
    }

    private String resolveExpression(String v) {
        return this.expressionResolver == null ? v : this.expressionResolver.resolveToString(v).orElseThrow(() -> "Failed to resolve topic expression: %s".formatted(v));
    }

    private Class<?> fromMessageTypeMapKey(String messageTypeKey) {
        try {
            return ClassUtils.forName((String)messageTypeKey, (ClassLoader)this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private String toMessageTypeMapKey(Class<?> messageType) {
        return messageType.getName();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)beanFactory;
            this.expressionResolver = new DefaultExpressionResolver(configurableBeanFactory);
        } else {
            this.logger.warn(() -> "Topic expressions on @PulsarMessage will not be resolved: bean factory must be %s but was %s".formatted(ConfigurableBeanFactory.class.getSimpleName(), beanFactory.getClass().getSimpleName()));
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

