/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogAccessor;
import org.springframework.pulsar.PulsarException;
import org.springframework.pulsar.core.PulsarClientBuilderCustomizer;
import org.springframework.pulsar.core.PulsarClientFactory;
import org.springframework.pulsar.core.PulsarClientProxy;
import org.springframework.util.Assert;

public class DefaultPulsarClientFactory
implements PulsarClientFactory,
EnvironmentAware {
    private final LogAccessor logger = new LogAccessor(this.getClass());
    private final PulsarClientBuilderCustomizer customizer;
    private boolean useRestartableClient;

    public DefaultPulsarClientFactory(String serviceUrl) {
        this((ClientBuilder clientBuilder) -> clientBuilder.serviceUrl(serviceUrl));
    }

    public DefaultPulsarClientFactory(PulsarClientBuilderCustomizer customizer) {
        Assert.notNull((Object)customizer, (String)"customizer must not be null");
        this.customizer = customizer;
    }

    @Override
    public PulsarClient createClient() {
        if (this.useRestartableClient) {
            this.logger.info(() -> "Using restartable client");
            return new PulsarClientProxy(this.customizer);
        }
        ClientBuilder clientBuilder = PulsarClient.builder();
        this.customizer.customize(clientBuilder);
        try {
            return clientBuilder.build();
        }
        catch (PulsarClientException ex) {
            throw new PulsarException(ex);
        }
    }

    public void setEnvironment(Environment environment) {
        this.useRestartableClient = (Boolean)environment.getProperty("spring.pulsar.client.restartable", Boolean.class, (Object)true);
    }
}

