/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.annotation;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.pulsar.core.PulsarTemplate;
import org.springframework.pulsar.core.PulsarTemplateCustomizer;
import org.springframework.util.CollectionUtils;

class PulsarTemplateBeanCustomizerPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private final LogAccessor logger = new LogAccessor(this.getClass());
    private ApplicationContext applicationContext;

    PulsarTemplateBeanCustomizerPostProcessor() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof PulsarTemplate) {
            PulsarTemplate template = (PulsarTemplate)bean;
            Map customizers = this.applicationContext.getBeansOfType(PulsarTemplateCustomizer.class);
            if (CollectionUtils.isEmpty((Map)customizers)) {
                return bean;
            }
            if (customizers.size() > 1) {
                this.logger.warn((CharSequence)"Found multiple %s beans [%s] - must be only 1 in order to apply".formatted(PulsarTemplateCustomizer.class.getSimpleName(), customizers.keySet()));
            } else {
                customizers.values().stream().forEach(c -> c.customize(template));
            }
        }
        return bean;
    }
}

