/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.Nullable;

interface RestartableComponentSupport
extends SmartLifecycle,
DisposableBean {
    public static final LogAccessor logger = new LogAccessor(RestartableComponentSupport.class);

    public static AtomicReference<State> initialState() {
        return new AtomicReference<State>(State.CREATED);
    }

    public AtomicReference<State> currentState();

    public LogAccessor logger();

    default public boolean isRunning() {
        return State.STARTED.equals((Object)this.currentState().get());
    }

    default public void start() {
        State current = this.currentState().getAndUpdate(state -> RestartableComponentSupport.isCreatedOrStopped(state) ? State.STARTING : state);
        if (RestartableComponentSupport.isCreatedOrStopped(current)) {
            this.logger().debug(() -> "Starting...");
            this.doStart();
            this.currentState().set(State.STARTED);
            this.logger().debug(() -> "Started");
        }
    }

    private static boolean isCreatedOrStopped(@Nullable State state) {
        return State.CREATED.equals((Object)state) || State.STOPPED.equals((Object)state);
    }

    default public void doStart() {
    }

    default public void stop() {
        State current = this.currentState().getAndUpdate(state -> RestartableComponentSupport.isCreatedOrStarted(state) ? State.STOPPING : state);
        if (RestartableComponentSupport.isCreatedOrStarted(current)) {
            this.logger().debug(() -> "Stopping...");
            this.doStop();
            this.currentState().set(State.STOPPED);
            this.logger().debug(() -> "Stopped");
        }
    }

    private static boolean isCreatedOrStarted(@Nullable State state) {
        return State.CREATED.equals((Object)state) || State.STARTED.equals((Object)state);
    }

    default public void doStop() {
    }

    default public void destroy() {
        this.logger().debug(() -> "Destroying...");
        this.stop();
        this.currentState().set(State.DESTROYED);
        this.logger().debug(() -> "Destroyed");
    }

    public static enum State {
        CREATED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        DESTROYED;

    }
}

