/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.lang.Nullable;

public final class Resolved<T> {
    @Nullable
    private final T value;
    @Nullable
    private final RuntimeException exception;

    private Resolved(@Nullable T value, @Nullable RuntimeException exception) {
        this.value = value;
        this.exception = exception;
    }

    public static <T> Resolved<T> of(T value) {
        return new Resolved<T>(value, null);
    }

    public static <T> Resolved<T> failed(String reason) {
        return new Resolved<Object>(null, new IllegalArgumentException(reason));
    }

    public static <T> Resolved<T> failed(RuntimeException e) {
        return new Resolved<Object>(null, e);
    }

    public Optional<T> get() {
        return Optional.ofNullable(this.value);
    }

    public void ifResolved(Consumer<? super T> action) {
        if (this.value != null) {
            action.accept(this.value);
        }
    }

    public T orElseThrow() {
        if (this.value == null && this.exception != null) {
            throw this.exception;
        }
        return this.value;
    }

    public T orElseThrow(Supplier<String> wrappingErrorMessage) {
        if (this.value == null && this.exception != null) {
            throw new RuntimeException(wrappingErrorMessage.get(), this.exception);
        }
        return this.value;
    }
}

