/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.support;

import java.util.Map;
import org.apache.pulsar.client.api.Message;
import org.springframework.pulsar.support.PulsarMessageHeaderMapper;

public class DefaultPulsarMessageHeaderMapper
implements PulsarMessageHeaderMapper {
    @Override
    public void toHeaders(Message<?> source, Map<String, Object> target) {
        target.putAll(source.getProperties());
        if (source.hasKey()) {
            target.put("pulsar_message_key", source.getKey());
            target.put("pulsar_message_key_bytes", source.getKeyBytes());
        }
        if (source.hasOrderingKey()) {
            target.put("pulsar_message_ordering_key", source.getOrderingKey());
        }
        if (source.hasIndex()) {
            target.put("pulsar_message_index", source.getIndex());
        }
        target.put("pulsar_message_id", source.getMessageId());
        target.put("pulsar_message_broker_publish_time", source.getBrokerPublishTime());
        target.put("pulsar_message_event_time", source.getEventTime());
        target.put("pulsar_message_size", source.size());
        target.put("pulsar_message_producer_name", source.getProducerName());
        target.put("pulsar_message_raw_data", source.getData());
        target.put("pulsar_message_publish_time", source.getPublishTime());
        target.put("pulsar_message_redelivery_count", source.getRedeliveryCount());
        target.put("pulsar_message_replicated_from", source.getReplicatedFrom());
        target.put("pulsar_message_schema_version", source.getSchemaVersion());
        target.put("pulsar_message_sequence_id", source.getSequenceId());
        target.put("pulsar_message_topic_name", source.getTopicName());
    }
}

