/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.listener;

import java.time.Duration;
import java.util.Properties;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.schema.SchemaType;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.pulsar.listener.AckMode;
import org.springframework.pulsar.observation.PulsarListenerObservationConvention;
import org.springframework.util.Assert;

public class PulsarContainerProperties {
    private static final Duration DEFAULT_CONSUMER_START_TIMEOUT = Duration.ofSeconds(30L);
    private Duration consumerStartTimeout = DEFAULT_CONSUMER_START_TIMEOUT;
    private String[] topics;
    private String topicsPattern;
    private String subscriptionName;
    private SubscriptionType subscriptionType = SubscriptionType.Exclusive;
    private Schema<?> schema;
    private SchemaType schemaType;
    private Object messageListener;
    private AsyncTaskExecutor consumerTaskExecutor;
    private int maxNumMessages = -1;
    private int maxNumBytes = 0xA00000;
    private int batchTimeoutMillis = 100;
    private boolean batchListener;
    private AckMode ackMode = AckMode.BATCH;
    private PulsarListenerObservationConvention observationConvention;
    private Properties pulsarConsumerProperties = new Properties();

    public PulsarContainerProperties(String ... topics) {
        this.topics = (String[])topics.clone();
        this.topicsPattern = null;
    }

    public PulsarContainerProperties(String topicPattern) {
        this.topicsPattern = topicPattern;
        this.topics = null;
    }

    public Object getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(Object messageListener) {
        this.messageListener = messageListener;
    }

    public AsyncTaskExecutor getConsumerTaskExecutor() {
        return this.consumerTaskExecutor;
    }

    public void setConsumerTaskExecutor(AsyncTaskExecutor consumerExecutor) {
        this.consumerTaskExecutor = consumerExecutor;
    }

    public SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    public void setSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public int getMaxNumMessages() {
        return this.maxNumMessages;
    }

    public void setMaxNumMessages(int maxNumMessages) {
        this.maxNumMessages = maxNumMessages;
    }

    public int getMaxNumBytes() {
        return this.maxNumBytes;
    }

    public void setMaxNumBytes(int maxNumBytes) {
        this.maxNumBytes = maxNumBytes;
    }

    public int getBatchTimeoutMillis() {
        return this.batchTimeoutMillis;
    }

    public void setBatchTimeoutMillis(int batchTimeoutMillis) {
        this.batchTimeoutMillis = batchTimeoutMillis;
    }

    public boolean isBatchListener() {
        return this.batchListener;
    }

    public void setBatchListener(boolean batchListener) {
        this.batchListener = batchListener;
    }

    public AckMode getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(AckMode ackMode) {
        this.ackMode = ackMode;
    }

    public PulsarListenerObservationConvention getObservationConvention() {
        return this.observationConvention;
    }

    public void setObservationConvention(PulsarListenerObservationConvention observationConvention) {
        this.observationConvention = observationConvention;
    }

    public Duration getConsumerStartTimeout() {
        return this.consumerStartTimeout;
    }

    public void setConsumerStartTimeout(Duration consumerStartTimeout) {
        Assert.notNull((Object)consumerStartTimeout, (String)"'consumerStartTimeout' cannot be null");
        this.consumerStartTimeout = consumerStartTimeout;
    }

    public Schema<?> getSchema() {
        return this.schema;
    }

    public void setSchema(Schema<?> schema) {
        this.schema = schema;
    }

    public String[] getTopics() {
        return this.topics;
    }

    public void setTopics(String[] topics) {
        this.topics = topics;
    }

    public String getTopicsPattern() {
        return this.topicsPattern;
    }

    public void setTopicsPattern(String topicsPattern) {
        this.topicsPattern = topicsPattern;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
    }

    public Properties getPulsarConsumerProperties() {
        return this.pulsarConsumerProperties;
    }

    public void setPulsarConsumerProperties(Properties pulsarConsumerProperties) {
        this.pulsarConsumerProperties = pulsarConsumerProperties;
    }
}

