/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.apache.pulsar.client.api.interceptor.ProducerInterceptor;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.core.ProducerBuilderCustomizer;
import org.springframework.pulsar.core.ProducerUtils;
import org.springframework.pulsar.core.PulsarOperations;
import org.springframework.pulsar.core.PulsarProducerFactory;
import org.springframework.pulsar.core.SchemaUtils;
import org.springframework.pulsar.core.TypedMessageBuilderCustomizer;
import org.springframework.pulsar.observation.DefaultPulsarTemplateObservationConvention;
import org.springframework.pulsar.observation.PulsarMessageSenderContext;
import org.springframework.pulsar.observation.PulsarTemplateObservation;
import org.springframework.pulsar.observation.PulsarTemplateObservationConvention;
import org.springframework.util.CollectionUtils;

public class PulsarTemplate<T>
implements PulsarOperations<T>,
BeanNameAware {
    private final LogAccessor logger = new LogAccessor(this.getClass());
    private final PulsarProducerFactory<T> producerFactory;
    @Nullable
    private final List<ProducerInterceptor> interceptors;
    @Nullable
    private final ObservationRegistry observationRegistry;
    @Nullable
    private final PulsarTemplateObservationConvention observationConvention;
    private String beanName = "";
    @Nullable
    private Schema<T> schema;

    public PulsarTemplate(PulsarProducerFactory<T> producerFactory) {
        this(producerFactory, null);
    }

    public PulsarTemplate(PulsarProducerFactory<T> producerFactory, @Nullable List<ProducerInterceptor> interceptors) {
        this(producerFactory, interceptors, null, null);
    }

    public PulsarTemplate(PulsarProducerFactory<T> producerFactory, @Nullable List<ProducerInterceptor> interceptors, @Nullable ObservationRegistry observationRegistry, @Nullable PulsarTemplateObservationConvention observationConvention) {
        this.producerFactory = producerFactory;
        this.interceptors = interceptors;
        this.observationRegistry = observationRegistry;
        this.observationConvention = observationConvention;
    }

    @Override
    public MessageId send(T message) throws PulsarClientException {
        return this.doSend(null, null, message, null, null);
    }

    @Override
    public MessageId send(@Nullable String topic, T message) throws PulsarClientException {
        return this.doSend(topic, null, message, null, null);
    }

    @Override
    public CompletableFuture<MessageId> sendAsync(T message) throws PulsarClientException {
        return this.doSendAsync(null, null, message, null, null);
    }

    @Override
    public CompletableFuture<MessageId> sendAsync(@Nullable String topic, T message) throws PulsarClientException {
        return this.doSendAsync(topic, null, message, null, null);
    }

    @Override
    public PulsarOperations.SendMessageBuilder<T> newMessage(T message) {
        return new SendMessageBuilderImpl<T>(this, message);
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setSchema(Schema<T> schema) {
        this.schema = schema;
    }

    private MessageId doSend(@Nullable String topic, @Nullable Collection<String> encryptionKeys, T message, @Nullable TypedMessageBuilderCustomizer<T> typedMessageBuilderCustomizer, @Nullable ProducerBuilderCustomizer<T> producerCustomizer) throws PulsarClientException {
        try {
            return this.doSendAsync(topic, encryptionKeys, message, typedMessageBuilderCustomizer, producerCustomizer).get();
        }
        catch (Exception ex) {
            throw PulsarClientException.unwrap((Throwable)ex);
        }
    }

    private CompletableFuture<MessageId> doSendAsync(@Nullable String topic, @Nullable Collection<String> encryptionKeys, T message, @Nullable TypedMessageBuilderCustomizer<T> typedMessageBuilderCustomizer, @Nullable ProducerBuilderCustomizer<T> producerCustomizer) throws PulsarClientException {
        String topicName = ProducerUtils.resolveTopicName(topic, this.producerFactory);
        this.logger.trace(() -> String.format("Sending msg to '%s' topic", topicName));
        PulsarMessageSenderContext senderContext = PulsarMessageSenderContext.newContext(topicName, this.beanName);
        Observation observation = this.newObservation(senderContext);
        try {
            observation.start();
            Producer<T> producer = this.prepareProducerForSend(topic, message, encryptionKeys, producerCustomizer);
            TypedMessageBuilder messageBuilder = producer.newMessage().value(message);
            if (typedMessageBuilderCustomizer != null) {
                typedMessageBuilderCustomizer.customize(messageBuilder);
            }
            senderContext.properties().forEach((arg_0, arg_1) -> ((TypedMessageBuilder)messageBuilder).property(arg_0, arg_1));
            return messageBuilder.sendAsync().whenComplete((msgId, ex) -> {
                if (ex == null) {
                    this.logger.trace(() -> String.format("Sent msg to '%s' topic", topicName));
                    observation.stop();
                } else {
                    this.logger.error(ex, () -> String.format("Failed to send msg to '%s' topic", topicName));
                    observation.error(ex);
                    observation.stop();
                }
                ProducerUtils.closeProducerAsync(producer, this.logger);
            });
        }
        catch (RuntimeException ex2) {
            observation.error((Throwable)ex2);
            observation.stop();
            throw ex2;
        }
    }

    private Observation newObservation(PulsarMessageSenderContext senderContext) {
        if (this.observationRegistry == null) {
            return Observation.NOOP;
        }
        return PulsarTemplateObservation.TEMPLATE_OBSERVATION.observation(this.observationConvention, DefaultPulsarTemplateObservationConvention.INSTANCE, () -> senderContext, this.observationRegistry);
    }

    private Producer<T> prepareProducerForSend(@Nullable String topic, T message, @Nullable Collection<String> encryptionKeys, @Nullable ProducerBuilderCustomizer<T> producerCustomizer) throws PulsarClientException {
        Schema<T> schema = this.schema != null ? this.schema : SchemaUtils.getSchema(message);
        ArrayList customizers = new ArrayList();
        if (!CollectionUtils.isEmpty(this.interceptors)) {
            customizers.add(builder -> this.interceptors.forEach(xva$0 -> builder.intercept(new ProducerInterceptor[]{xva$0})));
        }
        if (producerCustomizer != null) {
            customizers.add(producerCustomizer);
        }
        return this.producerFactory.createProducer(schema, topic, encryptionKeys, customizers);
    }

    public static class SendMessageBuilderImpl<T>
    implements PulsarOperations.SendMessageBuilder<T> {
        private final PulsarTemplate<T> template;
        private final T message;
        @Nullable
        private String topic;
        @Nullable
        private Collection<String> encryptionKeys;
        @Nullable
        private TypedMessageBuilderCustomizer<T> messageCustomizer;
        @Nullable
        private ProducerBuilderCustomizer<T> producerCustomizer;

        SendMessageBuilderImpl(PulsarTemplate<T> template, T message) {
            this.template = template;
            this.message = message;
        }

        @Override
        public PulsarOperations.SendMessageBuilder<T> withTopic(String topic) {
            this.topic = topic;
            return this;
        }

        @Override
        public PulsarOperations.SendMessageBuilder<T> withEncryptionKeys(Collection<String> encryptionKeys) {
            this.encryptionKeys = encryptionKeys;
            return this;
        }

        @Override
        public PulsarOperations.SendMessageBuilder<T> withMessageCustomizer(TypedMessageBuilderCustomizer<T> messageCustomizer) {
            this.messageCustomizer = messageCustomizer;
            return this;
        }

        @Override
        public PulsarOperations.SendMessageBuilder<T> withProducerCustomizer(ProducerBuilderCustomizer<T> producerCustomizer) {
            this.producerCustomizer = producerCustomizer;
            return this;
        }

        @Override
        public MessageId send() throws PulsarClientException {
            return this.template.doSend(this.topic, this.encryptionKeys, this.message, this.messageCustomizer, this.producerCustomizer);
        }

        @Override
        public CompletableFuture<MessageId> sendAsync() throws PulsarClientException {
            return this.template.doSendAsync(this.topic, this.encryptionKeys, this.message, this.messageCustomizer, this.producerCustomizer);
        }
    }
}

