/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.core.ProducerBuilderCustomizer;
import org.springframework.pulsar.core.TypedMessageBuilderCustomizer;

public interface PulsarOperations<T> {
    public MessageId send(T var1) throws PulsarClientException;

    public MessageId send(@Nullable String var1, T var2) throws PulsarClientException;

    public CompletableFuture<MessageId> sendAsync(T var1) throws PulsarClientException;

    public CompletableFuture<MessageId> sendAsync(@Nullable String var1, T var2) throws PulsarClientException;

    public SendMessageBuilder<T> newMessage(T var1);

    public static interface SendMessageBuilder<T> {
        public SendMessageBuilder<T> withTopic(String var1);

        public SendMessageBuilder<T> withEncryptionKeys(Collection<String> var1);

        public SendMessageBuilder<T> withMessageCustomizer(TypedMessageBuilderCustomizer<T> var1);

        public SendMessageBuilder<T> withProducerCustomizer(ProducerBuilderCustomizer<T> var1);

        public MessageId send() throws PulsarClientException;

        public CompletableFuture<MessageId> sendAsync() throws PulsarClientException;
    }
}

