/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.core.ProducerBuilderCustomizer;
import org.springframework.pulsar.core.ProducerUtils;
import org.springframework.pulsar.core.PulsarProducerFactory;
import org.springframework.util.CollectionUtils;

public class DefaultPulsarProducerFactory<T>
implements PulsarProducerFactory<T> {
    private final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private final Map<String, Object> producerConfig;
    private final PulsarClient pulsarClient;

    public DefaultPulsarProducerFactory(PulsarClient pulsarClient, Map<String, Object> config) {
        this.pulsarClient = pulsarClient;
        this.producerConfig = Collections.unmodifiableMap(config);
    }

    @Override
    public Producer<T> createProducer(Schema<T> schema) throws PulsarClientException {
        return this.doCreateProducer(schema, null, null, null);
    }

    @Override
    public Producer<T> createProducer(Schema<T> schema, @Nullable String topic) throws PulsarClientException {
        return this.doCreateProducer(schema, topic, null, null);
    }

    @Override
    public Producer<T> createProducer(Schema<T> schema, @Nullable String topic, @Nullable Collection<String> encryptionKeys, @Nullable List<ProducerBuilderCustomizer<T>> customizers) throws PulsarClientException {
        return this.doCreateProducer(schema, topic, encryptionKeys, customizers);
    }

    protected Producer<T> doCreateProducer(Schema<T> schema, @Nullable String topic, @Nullable Collection<String> encryptionKeys, @Nullable List<ProducerBuilderCustomizer<T>> customizers) throws PulsarClientException {
        String resolvedTopic = ProducerUtils.resolveTopicName(topic, this);
        this.logger.trace(() -> String.format("Creating producer for '%s' topic", resolvedTopic));
        ProducerBuilder producerBuilder = this.pulsarClient.newProducer(schema);
        HashMap<String, Object> config = new HashMap<String, Object>(this.producerConfig);
        if (encryptionKeys != null) {
            config.put("encryptionKeys", encryptionKeys);
        }
        DefaultPulsarProducerFactory.loadConf(producerBuilder, config);
        producerBuilder.topic(resolvedTopic);
        if (!CollectionUtils.isEmpty(customizers)) {
            customizers.forEach(c -> c.customize(producerBuilder));
        }
        return producerBuilder.create();
    }

    @Override
    public Map<String, Object> getProducerConfig() {
        return this.producerConfig;
    }

    private static <T> void loadConf(ProducerBuilder<T> producerBuilder, Map<String, Object> config) {
        producerBuilder.loadConf(config);
        if (config.containsKey("encryptionKeys")) {
            Collection keys = (Collection)config.get("encryptionKeys");
            keys.forEach(arg_0 -> producerBuilder.addEncryptionKey(arg_0));
        }
        if (config.containsKey("customMessageRouter")) {
            producerBuilder.messageRouter((MessageRouter)config.get("customMessageRouter"));
        }
        if (config.containsKey("batcherBuilder")) {
            producerBuilder.batcherBuilder((BatcherBuilder)config.get("batcherBuilder"));
        }
        if (config.containsKey("cryptoKeyReader")) {
            producerBuilder.cryptoKeyReader((CryptoKeyReader)config.get("cryptoKeyReader"));
        }
    }
}

