/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.core.ConsumerBuilderConfigurationUtil;
import org.springframework.pulsar.core.ConsumerBuilderCustomizer;
import org.springframework.pulsar.core.PulsarConsumerFactory;
import org.springframework.util.CollectionUtils;

public class DefaultPulsarConsumerFactory<T>
implements PulsarConsumerFactory<T> {
    private final Map<String, Object> consumerConfig;
    private final List<Consumer<T>> consumers = new ArrayList<Consumer<T>>();
    private final PulsarClient pulsarClient;

    public DefaultPulsarConsumerFactory(PulsarClient pulsarClient) {
        this(pulsarClient, Collections.emptyMap());
    }

    public DefaultPulsarConsumerFactory(PulsarClient pulsarClient, Map<String, Object> consumerConfig) {
        this.pulsarClient = pulsarClient;
        this.consumerConfig = Collections.unmodifiableMap(consumerConfig);
    }

    @Override
    public Consumer<T> createConsumer(Schema<T> schema) throws PulsarClientException {
        return this.createConsumer(schema, null, null, Collections.emptyList());
    }

    @Override
    public Consumer<T> createConsumer(Schema<T> schema, @Nullable Collection<String> topics) throws PulsarClientException {
        return this.createConsumer(schema, topics, null, Collections.emptyList());
    }

    @Override
    public Consumer<T> createConsumer(Schema<T> schema, @Nullable Collection<String> topics, @Nullable Map<String, String> properties, @Nullable List<ConsumerBuilderCustomizer<T>> customizers) throws PulsarClientException {
        ConsumerBuilder consumerBuilder = this.pulsarClient.newConsumer(schema);
        HashMap<String, Object> config = new HashMap<String, Object>(this.consumerConfig);
        if (topics != null) {
            config.put("topicNames", new HashSet<String>(topics));
        }
        if (properties != null) {
            config.put("properties", new TreeMap<String, String>(properties));
        }
        ConsumerBuilderConfigurationUtil.loadConf(consumerBuilder, config);
        if (!CollectionUtils.isEmpty(customizers)) {
            customizers.forEach(customizer -> customizer.customize(consumerBuilder));
        }
        Consumer consumer = consumerBuilder.subscribe();
        this.consumers.add(consumer);
        return consumer;
    }

    @Override
    public Map<String, Object> getConsumerConfig() {
        return this.consumerConfig;
    }
}

