/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.config.ListenerContainerFactory;
import org.springframework.pulsar.config.ListenerEndpoint;
import org.springframework.pulsar.config.ListenerEndpointRegistry;
import org.springframework.util.Assert;

public class PulsarListenerEndpointRegistrar
implements BeanFactoryAware,
InitializingBean {
    private final Class<? extends ListenerContainerFactory> type;
    private final List<PulsarListenerEndpointDescriptor> endpointDescriptors = new ArrayList<PulsarListenerEndpointDescriptor>();
    private ListenerEndpointRegistry endpointRegistry;
    private ListenerContainerFactory<?, ?> containerFactory;
    private String containerFactoryBeanName;
    private BeanFactory beanFactory;
    private boolean startImmediately;

    public PulsarListenerEndpointRegistrar(Class<? extends ListenerContainerFactory> type) {
        this.type = type;
    }

    public void setEndpointRegistry(ListenerEndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    @Nullable
    public ListenerEndpointRegistry getEndpointRegistry() {
        return this.endpointRegistry;
    }

    public void setContainerFactory(ListenerContainerFactory<?, ?> containerFactory) {
        this.containerFactory = containerFactory;
    }

    public void setContainerFactoryBeanName(String containerFactoryBeanName) {
        this.containerFactoryBeanName = containerFactoryBeanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        this.registerAllEndpoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerAllEndpoints() {
        List<PulsarListenerEndpointDescriptor> list = this.endpointDescriptors;
        synchronized (list) {
            for (PulsarListenerEndpointDescriptor descriptor : this.endpointDescriptors) {
                ListenerContainerFactory<?, ?> factory = this.resolveContainerFactory(descriptor);
                this.endpointRegistry.registerListenerContainer(descriptor.endpoint, factory);
            }
            this.startImmediately = true;
        }
    }

    private ListenerContainerFactory<?, ?> resolveContainerFactory(PulsarListenerEndpointDescriptor descriptor) {
        if (descriptor.containerFactory != null) {
            return descriptor.containerFactory;
        }
        if (this.containerFactory != null) {
            return this.containerFactory;
        }
        if (this.containerFactoryBeanName != null) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain container factory by bean name");
            this.containerFactory = (ListenerContainerFactory)this.beanFactory.getBean(this.containerFactoryBeanName, this.type);
            return this.containerFactory;
        }
        throw new IllegalStateException("Could not resolve the " + ListenerContainerFactory.class.getSimpleName() + " to use for [" + descriptor.endpoint + "] no factory was given and no default is set.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEndpoint(ListenerEndpoint endpoint, @Nullable ListenerContainerFactory<?, ?> factory) {
        Assert.notNull((Object)endpoint, (String)"Endpoint must be set");
        Assert.hasText((String)endpoint.getSubscriptionName(), (String)"Endpoint id must be set");
        PulsarListenerEndpointDescriptor descriptor = new PulsarListenerEndpointDescriptor(endpoint, factory);
        List<PulsarListenerEndpointDescriptor> list = this.endpointDescriptors;
        synchronized (list) {
            if (this.startImmediately) {
                this.endpointRegistry.registerListenerContainer(descriptor.endpoint, this.resolveContainerFactory(descriptor), true);
            } else {
                this.endpointDescriptors.add(descriptor);
            }
        }
    }

    private static final class PulsarListenerEndpointDescriptor {
        private final ListenerEndpoint endpoint;
        private final ListenerContainerFactory<?, ?> containerFactory;

        private PulsarListenerEndpointDescriptor(ListenerEndpoint endpoint, @Nullable ListenerContainerFactory<?, ?> containerFactory) {
            this.endpoint = endpoint;
            this.containerFactory = containerFactory;
        }
    }
}

