/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import org.apache.commons.logging.LogFactory;
import org.apache.pulsar.client.api.PulsarClient;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.config.PulsarClientConfiguration;

public class PulsarClientFactoryBean
extends AbstractFactoryBean<PulsarClient> {
    private final LogAccessor logger = new LogAccessor(LogFactory.getLog(((Object)((Object)this)).getClass()));
    private final PulsarClientConfiguration pulsarClientConfiguration;

    public PulsarClientFactoryBean(PulsarClientConfiguration pulsarClientConfiguration) {
        this.pulsarClientConfiguration = pulsarClientConfiguration;
    }

    public Class<?> getObjectType() {
        return PulsarClient.class;
    }

    protected PulsarClient createInstance() throws Exception {
        return PulsarClient.builder().loadConf(this.pulsarClientConfiguration.getConfigs()).build();
    }

    protected void destroyInstance(@Nullable PulsarClient instance) throws Exception {
        if (instance != null) {
            this.logger.info(() -> "Closing client " + instance);
            instance.close();
        }
    }
}

